% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{d50_dom}
\alias{d50_dom}
\title{D50 Dominance Index}
\usage{
d50_dom(cnt)
}
\arguments{
\item{cnt}{Numeric vector of non-negative counts (one entry per clone/
residue/OTU).  Zero counts are ignored.}
}
\value{
The smallest number of categories whose cumulative abundance is at
  least 50% of the total.
}
\description{
A convenience wrapper for `dxx_dom(cnt, 50)`. Calculates the minimum
number of top clones required to constitute 50% of the total abundance.
}
\examples{
d50_dom(c(100, 50, 20, 10, 5, rep(1, 5)))
}
