% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacencyMatrix.R
\name{adjacencyMatrix}
\alias{adjacencyMatrix}
\title{Adjacency Matrix From Amino Acid or Nucleotide Sequences}
\usage{
adjacencyMatrix(
  input.sequences,
  normalize = TRUE,
  sequence.dictionary = amino.acids,
  directed = FALSE
)
}
\arguments{
\item{input.sequences}{Character vector of sequences (amino acid or
nucleotide)}

\item{normalize}{Return the values as a normalized frequency (TRUE) or raw
counts (FALSE).}

\item{sequence.dictionary}{The letters to use in the matrix
(defaults to a standard 20 amino acids).}

\item{directed}{Logical; if FALSE (default) the matrix is symmetrised.}
}
\value{
An adjacency matrix.
}
\description{
Calculate frequency of adjacency between residues
along a set of biological sequences.
}
\examples{
# new.sequences <- generateSequences(prefix.motif = "CAS",
#                                      suffix.motif = "YF",
#                                      number.of.sequences = 100,
#                                      min.length = 8,
#                                      max.length = 16)
#
# adj.matrix <- adjacencyMatrix(new.sequences,
#                               normalize = TRUE)

}
