% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSCEfromTIFF.R
\name{readSCEfromTIFF}
\alias{readSCEfromTIFF}
\title{Generates a SingleCellExperiment from .tiff files}
\usage{
readSCEfromTIFF(x, image_df_path, panel_df_path, verbose = TRUE)
}
\arguments{
\item{x}{has to be a path to a folder containing .tiff files.}

\item{image_df_path}{has to be a path to a images.csv file, 
generated with the steinbock pipeline.}

\item{panel_df_path}{has to be a path to a panel.csv file, 
generated with the steinbock pipeline.}

\item{verbose}{logical indicating if additional information regarding the
spotted and acquired masses should be shown.}
}
\value{
returns a SCE object where pixels are stored as columns and acquired
channels are stored as rows.
}
\description{
Helper function to process .tiff files created with the 
steinbock pipeline into a \code{\linkS4class{SingleCellExperiment}}
object. This function is mainly used to read-in data generated from a
"spillover slide". Here, each .tiff file contains the measurements of
multiple pixels for a single stain across all open channels.
}
\section{Reading in .tiff files for spillover correction}{


As described in the original publication, single metal spots are acquired
using the Hyperion imaging system. Each acquisition corresponds to one spot.
All acquisitions are stored in a single .mcd file and individual acquisitions
are stored in single .tiff files after extraction with the steinbock pipeline.

This function aggregates these measurements into a single
\code{SingleCellExperiment} object:

\code{x} is a path:
All .tiff files are read in from the specified path. Here, the path
should indicate the location of the spillover slide measurement. Additionally,
the images.csv and panel.csv files generated with the steinbock pipeline 
must be passed. The column \code{acquisition_description} in images.csv 
as well as the column \code{channel} in panel.csv must contain the 
spotted metal isotope name in the format \code{(mt)(mass)} 
(e.g. \code{Sm152} for Samarium isotope with the atomic mass 152).
}

\examples{
# Read files from path
path <- system.file("extdata/spillover_tiff/img", package = "imcRtools")
image_df_path <- system.file("extdata/spillover_tiff/images.csv", package = "imcRtools")
panel_df_path <- system.file("extdata/spillover_tiff/panel.csv", package = "imcRtools")

sce <- readSCEfromTIFF(path, image_df_path, panel_df_path) 
sce


}
\references{
\href{https://www.sciencedirect.com/science/article/pii/S1550413118306910}{Chevrier,
S. et al. 2017. “Compensation of Signal Spillover in Suspension and Imaging
Mass Cytometry.” Cell Systems 6: 612–20.}
}
\author{
Victor Ibañez (\email{victor.ibanez@uzh.ch})
}
