% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{loadGFF3TrackFromURL}
\alias{loadGFF3TrackFromURL}
\title{load a GFF3 track which, with index, is served up by http}
\usage{
loadGFF3TrackFromURL(
  session,
  id,
  trackName,
  gff3URL,
  indexURL,
  color = "gray",
  colorTable,
  colorByAttribute,
  displayMode,
  trackHeight = 50,
  visibilityWindow,
  deleteTracksOfSameName = TRUE
)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{trackName}{character string}

\item{gff3URL}{character string http url for the bam file, 
typically very large}

\item{indexURL}{character string http url for the bam file index, 
typically small}

\item{color}{character #RGB or a recognized color name.  ignored if 
colorTable and colorByAttribute provided}

\item{colorTable}{list, mapping a gff3 attribute, typically biotype, 
to a color}

\item{colorByAttribute}{character, name of a gff3 attribute in column 9,
typically "biotype"}

\item{displayMode}{character,  "EXPANDED",  "SQUISHED" or "COLLAPSED"}

\item{trackHeight}{numeric defaults to 50}

\item{visibilityWindow}{numeric, Maximum window size in base pairs 
for which indexed annotations or variants are displayed}

\item{deleteTracksOfSameName}{logical, default TRUE}
}
\value{
nothing
}
\description{
load a remote GFF3 track
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo-GFF3.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{track_loaders}
