% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvR.R
\name{setCustomGenome,igvR-method}
\alias{setCustomGenome,igvR-method}
\alias{setCustomGenome}
\title{Specify the reference genome you wish to use, via full specification of all urls}
\usage{
\S4method{setCustomGenome}{igvR}(
  obj,
  id,
  genomeName,
  fastaURL,
  fastaIndexURL,
  chromosomeAliasURL = NA,
  cytobandURL = NA,
  geneAnnotationName = NA,
  geneAnnotationURL = NA,
  geneAnnotationTrackHeight = 200,
  geneAnnotationTrackColor = "darkblue",
  initialLocus = "all",
  visibilityWindow = 1e+06
)
}
\arguments{
\item{obj}{An object of class igvR}

\item{id}{character string, a short name, displayed in the browser, e.g., "hg38", "tair10".}

\item{genomeName}{character string, possibly longer, more descirptive then the id, e.g., "Human (GRCh38/hg38)"}

\item{fastaURL}{character string, e.g."https://s3.amazonaws.com/igv.broadinstitute.org/genomes/seq/hg38/hg38.fa"}

\item{fastaIndexURL}{character string, e.g. "https://s3.amazonaws.com/igv.broadinstitute.org/genomes/seq/hg38/hg38.fa.fai"}

\item{chromosomeAliasURL}{character string, default NA, a tab-delimited file supporting multiple equivalent chromosome names. see details}

\item{cytobandURL}{character string, default NA, a cytoband ideogram file in UCSC format, e.g. "https://s3.amazonaws.com/igv.broadinstitute.org/annotations/hg38/cytoBandIdeo.txt"}

\item{geneAnnotationName}{character string, e.g. "Refseq Genes", default NA}

\item{geneAnnotationURL}{character string, e.g. "https://s3.amazonaws.com/igv.org.genomes/hg38/refGene.txt.gz", default NA}

\item{geneAnnotationTrackHeight}{numeric, pixels, e.g. 500.  default 200}

\item{geneAnnotationTrackColor}{character string, any legal CSS color, default "darkblue"}

\item{initialLocus}{character string, e.g. "chr5:88,621,308-89,001,037" or "MEF2C"}

\item{visibilityWindow}{numeric, number of bases over which to display features, default 1000000}
}
\value{
An empty string, an error message if any of the urls could not be reached
}
\description{
Specify the reference genome you wish to use, via full specification of all urls
}
\examples{
if(interactive()){
   igv <- igvR()
   setCustomGenome(igv,
                   id="hg38",
                   genomeName="Human (GRCh38/hg38)",
                   fastaURL="https://s3.amazonaws.com/igv.broadinstitute.org/genomes/seq/hg38/hg38.fa",
                   fastaIndexURL="https://s3.amazonaws.com/igv.broadinstitute.org/genomes/seq/hg38/hg38.fa.fai",
                   chromosomeAliasURL=NA,
                   cytobandURL="https://s3.amazonaws.com/igv.broadinstitute.org/annotations/hg38/cytoBandIdeo.txt",
                   geneAnnotationName="Refseq Genes",
                   geneAnnotationURL="https://s3.amazonaws.com/igv.org.genomes/hg38/refGene.txt.gz",
                   geneAnnotationTrackHeight=300,
                   geneAnnotationTrackColor="darkgreen",
                   initialLocus="chr5:88,621,308-89,001,037",
                   visibilityWindow=5000000)
   }

}
