% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RemoteAlignmentTrack.R
\docType{class}
\name{RemoteAlignmentTrack-class}
\alias{RemoteAlignmentTrack-class}
\alias{.RemoteAlignmentTrack}
\alias{RemoteAlignmentTrack}
\title{Constructor for RemoteAlignmentTrack}
\usage{
RemoteAlignmentTrack(
  trackName,
  bamUrl,
  bamIndex = NULL,
  trackHeight = 50,
  visibilityWindow = 30000,
  color = "gray"
)
}
\arguments{
\item{trackName}{A character string, used as track label by igv, we recommend unique names per track.}

\item{bamUrl}{The URL of a bam file}

\item{bamIndex}{The URL of a bam index file. Defaults to <bamUrl>.bai}

\item{trackHeight}{track height, typically in range 20 (for annotations) and up to 1000 (for large sample vcf files)}

\item{visibilityWindow}{Maximum window size in base pairs for which indexed annotations or variants are displayed. Defaults: 1 MB for variants, whole chromosome for other track types.}

\item{color}{A character string, either a reconized color ("red") or a hex string ("#FF8532")}
}
\value{
A RemoteAlignmentTrack object
}
\description{
\code{RemoteAlignmentTrack} creates an \code{IGV} track for remote bam files
}
\details{
Detailed description goes here
}
