% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFrameAnnotationTrack.R
\docType{class}
\name{DataFrameAnnotationTrack-class}
\alias{DataFrameAnnotationTrack-class}
\alias{.DataFrameAnnotationTrack}
\alias{DataFrameAnnotationTrack}
\title{Constructor for DataFrameAnnotationTrack}
\usage{
DataFrameAnnotationTrack(
  trackName,
  annotation,
  color = "",
  displayMode = "SQUISHED",
  trackHeight = 50,
  expandedRowHeight = 30,
  squishedRowHeight = 15,
  maxRows = 500,
  searchable = FALSE,
  visibilityWindow = 1e+05
)
}
\arguments{
\item{trackName}{A character string, used as track label by igv, we recommend unique names per track.}

\item{annotation}{A base R \code{data.frame}}

\item{color}{A CSS color name (e.g., "red" or "#FF0000"), leave as default empty string if supplying bed9 format with itemRgb.}

\item{displayMode}{"COLLAPSED", "SQUISHED" or "EXPANDED".  Spelling and case must be precise.}

\item{trackHeight}{track height, typically in range 20 (for annotations) and up to 1000 (for large sample vcf files)}

\item{expandedRowHeight}{Height of each row of features in "EXPANDED" mode.}

\item{squishedRowHeight}{Height of each row of features in "SQUISHED" mode, for compact viewing.}

\item{maxRows}{of features to display}

\item{searchable}{If TRUE, labels on annotation elements may be used in search}

\item{visibilityWindow}{Maximum window size in base pairs for which indexed annotations or variants are displayed. Defaults: 1 MB for variants, whole chromosome for other track types.}
}
\value{
A DataFrameAnnotationTrack object
}
\description{
\code{DataFrameAnnotationTrack} creates an \code{IGV} track for bed objects imported using \code{rtracklayer}
}
\details{
Detailed description goes here
}
\examples{
base.loc <- 88883100
tbl <- data.frame(chrom=rep("chr5", 3),
                  start=c(base.loc, base.loc+100, base.loc + 250),
                  end=c(base.loc + 50, base.loc+120, base.loc+290),
                  name=c("a", "b", "c"),
                  score=runif(3),
                  strand=rep("*", 3),
                  stringsAsFactors=FALSE)

track <- DataFrameAnnotationTrack("data.frame demo", tbl)

if(interactive()){
   igv <- igvR()
   setGenome(igv, "hg38")
   setBrowserWindowTitle(igv, "DataFrameAnnotationTrack demo")
   displayTrack(igv, track)
   roi <- sprintf("\%s:\%d-\%d", tbl$chrom[1], min(tbl$start)-100, max(tbl$start) + 100)
   showGenomicRegion(igv, roi)
   Sys.sleep(1)
   zoomOut(igv)
   }

}
