% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaledHydropathy.R
\name{meanScaledHydropathy}
\alias{meanScaledHydropathy}
\title{Calculate the Mean Scaled Hydropathy}
\usage{
meanScaledHydropathy(sequence, roundScore = NA)
}
\arguments{
\item{sequence}{amino acid sequence as a single character string,
a vector of single characters, or an AAString object.
It also supports a single character string that specifies
the path to a .fasta or .fa file.}

\item{roundScore}{Number of decimals the score will be rounded to.
NA by default.}
}
\value{
A numeric value equal to the Mean Scaled Hydropathy.
}
\description{
This function utilizes the scaledHydropathyGlobal() function and
  easily returns the averaged hydropathy as a numeric value.
}
\examples{
#Amino acid sequences can be character strings
aaString <- "ACDEFGHIKLMNPQRSTVWY"
#Amino acid sequences can also be character vectors
aaVector <- c("A", "C", "D", "E", "F",
              "G", "H", "I", "K", "L",
              "M", "N", "P", "Q", "R",
              "S", "T", "V", "W", "Y")
 #Alternatively, .fasta files can also be used by providing

#Calculate the mean scaled hydropathy
 meanScaledHydropathy(aaString)
 meanScaledHydropathy(aaVector)
}
\references{
Kyte, J., & Doolittle, R. F. (1982). A simple method for
  displaying the hydropathic character of a protein.
  Journal of molecular biology, 157(1), 105-132.
}
\seealso{
\code{\link{KDNorm}} for residue values.

Other scaled hydropathy functions: 
\code{\link{KDNorm}},
\code{\link{foldIndexR}()},
\code{\link{scaledHydropathyGlobal}()},
\code{\link{scaledHydropathyLocal}()}
}
\concept{scaled hydropathy functions}
