% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goseqTable.R
\name{goseqTable}
\alias{goseqTable}
\title{Extract functional terms enriched in the DE genes, based on goseq}
\usage{
goseqTable(
  de.genes,
  assayed.genes,
  genome = "hg38",
  id = "ensGene",
  testCats = c("GO:BP", "GO:MF", "GO:CC"),
  FDR_GO_cutoff = 1,
  nTop = 200,
  orgDbPkg = "org.Hs.eg.db",
  addGeneToTerms = TRUE
)
}
\arguments{
\item{de.genes}{A vector of (differentially expressed) genes}

\item{assayed.genes}{A vector of background genes, e.g. all (expressed) genes
in the assays}

\item{genome}{A string identifying the genome that genes refer to, as in the
\code{\link[goseq:goseq]{goseq::goseq()}} function}

\item{id}{A string identifying the gene identifier used by genes, as in the
\code{\link[goseq:goseq]{goseq::goseq()}} function}

\item{testCats}{A vector specifying which categories to test for over representation amongst DE genes - can be any combination of "GO:CC", "GO:BP", "GO:MF" & "KEGG"}

\item{FDR_GO_cutoff}{Numeric value for subsetting the results}

\item{nTop}{Number of categories to extract, and optionally process for adding
genes to the respective terms}

\item{orgDbPkg}{Character string, named as the \code{org.XX.eg.db}
package which should be available in Bioconductor}

\item{addGeneToTerms}{Logical, whether to add a column with all genes annotated
to each GO term}
}
\value{
A table containing the computed GO Terms and related enrichment scores
}
\description{
A wrapper for extracting functional GO terms enriched in a list of (DE) genes,
based on the algorithm and the implementation in the goseq package
}
\details{
Note: the feature length retrieval is based on the \code{\link[goseq:goseq]{goseq::goseq()}} function,
and requires that the corresponding TxDb packages are installed and available
}
\examples{

library("airway")
data("airway", package = "airway")
airway
dds_airway <- DESeq2::DESeqDataSetFromMatrix(assay(airway),
  colData = colData(airway),
  design = ~ cell + dex
)
dds_airway <- DESeq2::DESeq(dds_airway)
res_airway <- DESeq2::results(dds_airway)

res_subset <- mosdef::deresult_to_df(res_airway)[1:100, ]
myde <- res_subset$id
myassayed <- rownames(res_airway)
\dontrun{
mygo <- goseqTable(myde,
  myassayed,
  testCats = "GO:BP",
  addGeneToTerms = FALSE
)
head(mygo)
}

}
