% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res2tbl.R
\name{deseqresult2tbl}
\alias{deseqresult2tbl}
\title{Generate a tidy table with the results of DESeq}
\usage{
deseqresult2tbl(deseqresult)
}
\arguments{
\item{deseqresult}{A \code{\link[DESeq2:DESeqResults]{DESeq2::DESeqResults()}} object}
}
\value{
A "tidy" data.frame with all genes
}
\description{
Generate a tidy table with the results of DESeq
}
\examples{

# with simulated data...
library(DESeq2)
dds <- DESeq2::makeExampleDESeqDataSet(n = 100, m = 8, betaSD = 1)
dds <- DESeq2::DESeq(dds)
res <- DESeq2::results(dds)
deseqresult2tbl(res)
}
