% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{sampleInfo}
\alias{sampleInfo}
\alias{sampleInfo<-}
\alias{sampleInfo,CapSet-method}
\alias{sampleInfo<-,CapSet-method}
\title{Retrieve and replace sample information of a CapSet object}
\usage{
sampleInfo(object, ...)

sampleInfo(object, ...) <- value

\S4method{sampleInfo}{CapSet}(object)

\S4method{sampleInfo}{CapSet}(object) <- value
}
\arguments{
\item{object}{The \code{\link{CapSet}} object}

\item{...}{Additional options}

\item{value}{Replacement DataFrame object}
}
\value{
sample information data.frame
}
\description{
Retrieve and replace sample information of a CapSet object
}
\examples{

# load a previously saved CapSet object
cs <- exampleCSobject()
# get sampleinfo
si <- sampleInfo(cs)
# modify
si$samples <- paste0("sample_", seq_along(1:nrow(si)) )
# replace
sampleInfo(cs) <- si
}
