% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/detectDiffTSS.R
\name{detectDiffTSS}
\alias{detectDiffTSS}
\alias{detectDiffTSS,DGEGLM-method}
\alias{detectDiffTSS,DESeqDataSet-method}
\title{Detect differentially expressed Transcription Start Sites between two conditions (test)}
\usage{
detectDiffTSS(fit, testGroup, contGroup, TSSfile = NULL, MAplot_fdr = NA)

\S4method{detectDiffTSS}{DGEGLM}(fit, testGroup, contGroup, TSSfile = NULL, MAplot_fdr = NA)

\S4method{detectDiffTSS}{DESeqDataSet}(fit, testGroup, contGroup, MAplot_fdr = NA)
}
\arguments{
\item{fit}{DGEGLM object (output of \code{\link{fitDiffTSS}} command )}

\item{testGroup}{Test group name}

\item{contGroup}{Control group name}

\item{TSSfile}{The TSS .bed file used for \code{\link{fitDiffTSS}} command (if method "edgeR" was used)}

\item{MAplot_fdr}{FDR threshold to mark differentially expressed TSS in MAplot (NA = Don't make an MAplot)}
}
\value{
A \code{\link{GRanges}} object containing p-values of differential expression for each TSS.
}
\description{
Detect differentially expressed Transcription Start Sites between two conditions (test)
}
\examples{

# before running this
# 1. Create a CapSet object
# 2. de-multiplex the fastqs
# 3. map them
# 4. filter duplicate reads from mapped BAM
# 5. detect TSS
# 6. fit the diff TSS model.

\dontrun{
# load a previously saved DGEGLM object from step 5
csfit <- load("diffTSS_fit.Rdata")
dir <- system.file("extdata", package = "icetea")
# detect differentially expressed TSS between groups (return MA plot)
detectDiffTSS(csfit, testGroup = "mut", controlGroup = "wt",
               tssFile = file.path(dir, "testTSS_merged.bed"), MAplot_fdr = 0.05)

}

\dontrun{
# load a previously saved DGEGLM object from step 5
csfit <- load("diffTSS_fit.Rdata")
dir <- system.file("extdata", package = "icetea")
# detect differentially expressed TSS between groups (return MA plot)
detectDiffTSS(csfit, testGroup = "mut", controlGroup = "wt", MAplot_fdr = 0.05)

}

}
