% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneSetTable.R
\name{GeneSetTable-class}
\alias{GeneSetTable-class}
\alias{GeneSetTable}
\alias{initialize,GeneSetTable-method}
\alias{.fullName,GeneSetTable-method}
\alias{.panelColor,GeneSetTable-method}
\alias{.defineDataInterface,GeneSetTable-method}
\alias{.hideInterface,GeneSetTable-method}
\alias{.defineOutput,GeneSetTable-method}
\alias{.generateOutput,GeneSetTable-method}
\alias{.createObservers,GeneSetTable-method}
\alias{.renderOutput,GeneSetTable-method}
\alias{.multiSelectionDimension,GeneSetTable-method}
\alias{.multiSelectionActive,GeneSetTable-method}
\alias{.multiSelectionCommands,GeneSetTable-method}
\alias{.multiSelectionAvailable,GeneSetTable-method}
\alias{.multiSelectionClear,GeneSetTable-method}
\title{Gene set table}
\description{
A table where each row is a gene set and can be clicked to transmit a multiple feature selection to another panel.
This has been deprecated in favor of the simpler \linkS4class{FeatureSetTable}.
}
\section{Slot overview}{

The following slots control the type of gene sets to show:
\itemize{
\item \code{Type}, string specifying the type of gene set collection to show.
Defaults to \code{"GO"}.
}

The following slots control the table selections:
\itemize{
\item \code{Selected}, a string containing the name of the currently selected gene set.
Defaults to \code{""}, i.e., no selection.
\item \code{Search}, a string containing the regular expression for the global search.
Defaults to \code{""}, i.e., no search.
\item \code{SearchColumns}, a character vector where each entry contains the search string for each column.
Defaults to an empty character vector, i.e., no search.
}

In addition, this class inherits all slots from its parent \linkS4class{Panel} class.
}

\section{Constructor}{

\code{GeneSetTable(...)} creates an instance of a GeneSetTable class,
where any slot and its value can be passed to \code{...} as a named argument.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{GeneSetTable} class.
Refer to the documentation for each method for more details on the remaining arguments.

For defining the interface:
\itemize{
\item \code{\link{.defineDataInterface}(x, se, select_info)} returns a list of interface elements for manipulating all slots described above.
\item \code{\link{.panelColor}(x)} will return the specified default color for this panel class.
\item \code{\link{.fullName}(x)} will return \code{"Gene set table"}.
\item \code{\link{.hideInterface}(x)} will return \code{TRUE} for UI elements related to multiple selections,
otherwise calling the method for \linkS4class{Panel}.
\item \code{\link{.defineOutput}(x)} will return a HTML element containing a \code{\link{datatable}} widget.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all new slots described above, as well as in the parent classes via the \linkS4class{Panel} method.
}

For creating the table:
\itemize{
\item \code{\link{.generateOutput}(x, envir)} will create a data.frame of gene set descriptions in \code{envir},
based on the \code{mode="show"} output of \code{\link{.getGeneSetCommands}}.
It will also return the commands required to do so and the name of the variable corresponding to said data.frame.
\item \code{\link{.renderOutput}(x, se, ..., output, pObjects, rObjects)}
will add a \code{\link{datatable}} widget to the output,
which is used to render the aforementioned data.frame.
}

For controlling the multiple selections:
\itemize{
\item \code{\link{.multiSelectionDimension}(x)} returns \code{"row"}.
\item \code{\link{.multiSelectionCommands}(x, index)} returns a string specifying the commands to be used to extract the identities of the genes in the currently selected set, based on the \code{mode="extract"} output of \code{\link{.getGeneSetCommands}}.
\code{index} is ignored.
\item \code{\link{.multiSelectionActive}(x)} returns the name of the currently selected gene set,
unless no selection is made, in which case \code{NULL} is returned.
\item \code{\link{.multiSelectionClear}(x)} returns \code{x} but with the \code{Selected} slot replaced by an empty string.
\item \code{\link{.multiSelectionAvailable}(x, contents)} returns \code{contents$available},
which is set to the number of features in \code{se}.
}
}

\examples{
library(scRNAseq)
sce <- LunSpikeInData(location=FALSE)

library(scater)
sce <- logNormCounts(sce)

library(scran)
rowData(sce) <- cbind(rowData(sce), modelGeneVarWithSpikes(sce, "ERCC"))

# This defaults to 'org.Hs.eg.db' with 'ENTREZID'.
.setOrganism("org.Mm.eg.db")
.setIdentifierType("ENSEMBL")
gst <- GeneSetTable(PanelId=1L)

rdp <- RowDataPlot(RowSelectionSource="GeneSetTable1",
    ColorBy="Row selection",
    XAxis="Row data", XAxisRowData="mean", YAxis="total")

rdt <- RowDataTable(RowSelectionSource="GeneSetTable1")

if (interactive()) {
    iSEE(sce, initial=list(gst, rdp, rdt))
}

}
\author{
Aaron Lun
}
