% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/class-ColumnTreePlot.R
\docType{class}
\name{ColumnTreePlot-class}
\alias{ColumnTreePlot-class}
\alias{ColumnTreePlot}
\title{Column tree plot}
\value{
The \code{ColumnTreePlot(...)} constructor creates an instance of a
ColumnTreePlot class, where any slot and its value can be passed to
\code{...} as a named argument.
}
\description{
Hierarchical tree for the columns of a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-constructor]{TreeSummarizedExperiment}}
object. The tree represents the sample hierarchy of the study and gets stored
in the \code{\link[TreeSummarizedExperiment:rowLinks]{colTree}} slot of the
experiment object. The panel implements \code{\link[miaViz:plotTree]{plotColTree}}
to generate the plot.
}
\section{Slot overview}{


This class inherits all slots from its parent class \linkS4class{TreePlot}.
}

\examples{
# Import TreeSE
library(mia)
data("Tengeler2020", package = "mia")
tse <- Tengeler2020

# Store panel into object
panel <- ColumnTreePlot()
# View some adjustable parameters
head(slotNames(panel))

# Launch iSEE with custom initial panel
if (interactive()) {
  iSEE(tse, initial = c(panel))
}

}
\seealso{
\linkS4class{TreePlot}
\linkS4class{RowTreePlot}
}
\author{
Giulio Benedetti
}
