% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/utils-SummarizedExperiment.R
\docType{methods}
\name{utils-SummarizedExperiment}
\alias{utils-SummarizedExperiment}
\alias{embedContrastResults}
\alias{embedContrastResultsMethods}
\alias{embedContrastResults,ANY-method}
\alias{embedContrastResults,data.frame-method}
\title{Generics for Embbedding Results into a SummarizedExperiment Object}
\format{
\code{embedContrastResultsMethods}: Named character vector mapping keywords to class names designed to store differential expression results.
}
\usage{
embedContrastResults(x, se, name, ...)

embedContrastResultsMethods

\S4method{embedContrastResults}{ANY}(x, se, name, ...)

\S4method{embedContrastResults}{data.frame}(x, se, name, class, ...)
}
\arguments{
\item{x}{Object to be embedded.}

\item{se}{A \linkS4class{SummarizedExperiment} object.}

\item{name}{Identifier for the embedded object.}

\item{...}{Arguments passed to and from other methods.}

\item{class}{Class to use for embedding \code{x}. Only used when \code{class(x)} does
not uniquely identify the package that generated the object.}
}
\value{
An updated \linkS4class{SummarizedExperiment} object that contains the
embedded object.
}
\description{
An overview of the generics for embedding results into a \linkS4class{SummarizedExperiment} object, in a format compatible with \pkg{iSEEde}.
}
\section{Definitions}{

\itemize{
\item \code{embedContrastResults(x, se, name, ...)} embeds the results \code{x} in the \linkS4class{SummarizedExperiment} \code{se}.
}
}

\examples{
embedContrastResultsMethods

showMethods(embedContrastResults)
}
\author{
Kevin Rue-Albrecht
}
\keyword{datasets}
