% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{table-generics}
\alias{table-generics}
\alias{.generateTable}
\alias{.showSelectionDetails}
\title{Generics for table construction}
\description{
Generic to control the creation of a data.frame to show in the \code{\link{datatable}} widget of a \linkS4class{Table} panel.
\linkS4class{Table} subclasses can specialize methods to modify the behavior of \code{\link{.generateOutput}}.
}
\section{Constructing the table}{

\code{.generateTable(x, envir)} generates the data.frame to use in the \code{\link{datatable}} widget.
The following arguments are required:
\itemize{
\item \code{x}, an instance of a Table subclass.
\item \code{envir}, the evaluation environment in which the data.frame is to be constructed.
This can be assumed to have \code{se}, the \linkS4class{SummarizedExperiment} object containing the current dataset;
possibly \code{col_selected}, if a multiple column selection is being transmitted to \code{x};
and possibly \code{row_selected}, if a multiple row selection is being transmitted to \code{x}.
}

In return, the method should add a \code{tab} variable in \code{envir} containing the relevant data.frame.
This will automatically be passed to the \code{\link{datatable}} widget as well as being stored in \code{pObjects$contents}.
The return value should be a character vector of commands that produces \code{tab} when evaluated in \code{envir}.

Each row of the \code{tab} data.frame should correspond to one row or column in the SummarizedExperiment \code{envir$se} for \linkS4class{RowTable}s and \linkS4class{ColumnTable}s respectively.
Unlike \code{\link{.generateDotPlotData}}, it is not necessary for all rows or columns to be represented in this data.frame.

Ideally, the number and names of the columns of the data.frame should be fixed for all calls to \code{.generateTable}.
Violating this principle may result in unpredictable interactions with existing values in the \code{SearchColumns} slot.
Nonetheless, the app will be robust to mismatches, see \code{\link{filterDT}} for more details.

Any internal variables that are generated by the commands should be prefixed with \code{.} to avoid potential clashes with reserved variable names in the rest of the application.

This generic is called by \code{.generateOutput} for Table subclasses.
Thus, developers of such subclasses only need to specialize \code{.generateTable} to change the table contents, without needing to reimplement the entirety of \code{.generateOutput}.
}

\section{Adding details on the selection}{

\code{.showSelectionDetails(x)} should return a HTML element containing details on the currently selected row,
given an instance of a Table subclass \code{x}.
The identity of the selected row should be extracted from \code{x[["Selected"]]}.
The element will only be rerendered upon a single selection in the Table.
Alternatively, it may return \code{NULL} in which case no selection details are shown in the interface.
}

\author{
Aaron Lun
}
