% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExperimentColorMap.R
\name{synchronizeAssays}
\alias{synchronizeAssays}
\title{Synchronize assay colormaps to match those in a SummarizedExperiment}
\usage{
synchronizeAssays(ecm, se)
}
\arguments{
\item{ecm}{An \linkS4class{ExperimentColorMap}.}

\item{se}{A \linkS4class{SingleCellExperiment}.}
}
\value{
An \linkS4class{ExperimentColorMap} with colormaps in the
\code{assay} slot synchronized to match the position of the corresponding
assay in the SingleCellExperiment.
}
\description{
This function returns an updated \linkS4class{ExperimentColorMap}
in which colormaps in the \code{assays} slot
are ordered to match the position of their corresponding
assay in the \linkS4class{SingleCellExperiment} object.
Assays in the SingleCellExperiment that do not have a match
in the ExperimentColorMap are assigned the appropriate default colormap.
}
\details{
It is highly recommended to name \emph{all} assays in both
ExperimentColorMap and SummarizedExperiment prior to calling this function,
as this will facilitate the identification of matching assays
between the two objects. In most cases, unnamed colormaps will be dropped
from the new ExperimentColorMap object.

The function supports three main situations:

\itemize{

\item If \emph{all} assays in the SingleCellExperiment are named,
this function
will populate the \code{assays} slot of the new ExperimentColorMap
with the name-matched colormap from the input ExperimentColorMap,
if available.
Assays in the SingleCellExperiment that do not have a colormap defined
in the ExperimentColorMap are assigned the appropriate default colormap.

\item If \emph{all} assays in the SingleCellExperiment are unnamed, this function
requires that the ExperimentColorMap supplies a number of assay colormaps
\emph{identical} to the number of assays in the SingleCellExperiment object.
In that case, the ExperimentColorMap object will be returned \emph{as is}.

\item If only a subset of assays in the SingleCellExperiment are named,
this function will ignore unnamed colormaps in the ExperimentColorMap;
It will populate the \code{assays} slot of the new ExperimentColorMap
with the name-matched colormap from the input ExperimentColorMap,
if available.
Assays in the SingleCellExperiment that are unnamed, or that
do not have a colormap defined
in the ExperimentColorMap are assigned the appropriate default colormap.


}
}
\examples{

# Example ExperimentColorMap ----

count_colors <- function(n){
  c("black","brown","red","orange","yellow")
}
fpkm_colors <- viridis::inferno

ecm <- ExperimentColorMap(
    assays = list(
        counts = count_colors,
        tophat_counts = count_colors,
        cufflinks_fpkm = fpkm_colors,
        rsem_counts = count_colors,
        orphan = count_colors,
        orphan2 = count_colors,
        count_colors,
        fpkm_colors
    )
)

# Example SingleCellExperiment ----

library(scRNAseq)
sce <- ReprocessedAllenData(assays="tophat_counts")
library(scater)
sce <- logNormCounts(sce, exprs_values="tophat_counts")
sce <- runPCA(sce)
sce <- runTSNE(sce)

# Example ----

ecm_sync <- synchronizeAssays(ecm, sce)

}
\author{
Kevin Rue-Albrecht
}
