% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_class.R
\name{.setCachedCommonInfo}
\alias{.setCachedCommonInfo}
\alias{.getCachedCommonInfo}
\title{Set and get cached commons}
\usage{
.setCachedCommonInfo(se, cls, ...)

.getCachedCommonInfo(se, cls)
}
\arguments{
\item{se}{A \linkS4class{SummarizedExperiment} object containing the current dataset.}

\item{cls}{String containing the name of the class for which this information is cached.}

\item{...}{Any number of named R objects to cache.}
}
\value{
\code{.setCachedCommonInfo} returns \code{se} with \code{...} added to its \code{\link{int_metadata}}.

\code{.getCachedCommonInfo} retrieves the cached common information for class \code{cls}.
}
\description{
Get and set common cached information for each class.
The setter should only ever be called in \code{\link{.cacheCommonInfo}}.
The getter can be called anywhere but most usually in \code{\link{.defineInterface}}.
}
\examples{
se <- SummarizedExperiment()
se <- .setCachedCommonInfo(se, "SomePanelClass",
    something=1, more_things=TRUE, something_else="A")
.getCachedCommonInfo(se, "SomePanelClass")

}
\seealso{
\code{?"\link{cache-utils}"}, for utilities to define some cached variables.
}
\author{
Aaron Lun
}
