% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_reactive.R
\name{.requestUpdate}
\alias{.requestUpdate}
\alias{.requestCleanUpdate}
\alias{.requestActiveSelectionUpdate}
\title{Request Panel updates}
\usage{
.requestUpdate(panel_name, rObjects)

.requestCleanUpdate(panel_name, pObjects, rObjects)

.requestActiveSelectionUpdate(
  panel_name,
  session,
  pObjects,
  rObjects,
  update_output = TRUE
)
}
\arguments{
\item{panel_name}{String containing the panel name.}

\item{rObjects}{A reactive list of values generated in the \code{\link{iSEE}} app.}

\item{pObjects}{An environment containing global parameters generated in the \code{\link{iSEE}} app.}

\item{session}{The Shiny session object from the server function.}

\item{update_output}{A logical scalar indicating whether to call \code{.requestUpdate} as well.}
}
\value{
\code{.requestUpdate} will modify \code{rObjects} to request a re-rendering of the specified panel.

\code{.requestCleanUpdate} will also remove all active/saved selections in the chosen panel.

\code{.requestActiveSelectionUpdate} will modify \code{rObjects} to indicate that the active multiple selection for \code{panel_name} has changed.
If \code{update_output=TRUE}, it will also request a re-rendering of the panel.

All functions will invisibly return \code{NULL}.
}
\description{
Request a re-rendering of the \linkS4class{Panel} output via reactive variables.
}
\details{
\code{.requestUpdate} should be used in various observers to request a re-rendering of the panel,
usually in response to user-driven parameter changes in \code{\link{.createObservers}}.

\code{.requestCleanUpdate} is used for changes to protected parameters that invalidate existing multiple selections,
e.g., if the coordinates change in a \linkS4class{DotPlot}, existing brushes and lassos are usually not applicable.

\code{.requestActiveSelectionUpdate} should be used in the observer expression that implements the panel's multiple selection mechanism.
}
\seealso{
\code{\link{.createProtectedParameterObservers}}, for examples where the update-requesting functions are used.
}
\author{
Aaron Lun
}
