% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs_heatmap.R
\name{.extractAssaySubmatrix}
\alias{.extractAssaySubmatrix}
\title{Extract assay submatrix}
\usage{
.extractAssaySubmatrix(
  x,
  se,
  envir,
  use_custom_row_slot,
  custom_row_text_slot,
  cap_row_selection_slot = NULL,
  as_matrix = TRUE
)
}
\arguments{
\item{x}{A \linkS4class{Panel} instance that uses the row selection modal.}

\item{se}{The current \linkS4class{SummarizedExperiment} object.}

\item{envir}{The evaluation environment.
This assumes that \code{\link{.processMultiSelections}} has already been run.}

\item{use_custom_row_slot}{String specifying the name of the slot indicating whether to use custom rows.}

\item{custom_row_text_slot}{String specifying the name of the slot holding the custom row names.
This is expected to be of the same format as described in \code{?\link{.createCustomDimnamesModalObservers}}.}

\item{cap_row_selection_slot}{String specifying the name of the slot containing the cap on the number of selected rows.}

\item{as_matrix}{Logical scalar indicating whether to coerce the submatrix into an ordinary matrix.
If \code{FALSE}, the existing matrix representation is preserved.}
}
\value{
A character vector of commands to set up the assay submatrix.
The submatrix itself is generated within \code{envir} as the \code{plot.data} variable.
}
\description{
Extract an assay submatrix based on the multiple row/column selection and any custom specifications from \code{\link{.createCustomDimnamesModalObservers}}.
}
\details{
This is designed to extract a matrix of assay values for a subset of rows/columns of interest, most typically for a \linkS4class{ComplexHeatmapPlot}.
It assumes that the class of \code{x} contains a slot indicating whether custom rows should be used, plus a slot to hold the selected custom row names (usually from a modal, see \code{\link{.createCustomDimnamesModalObservers}}).

If a multiple row selection is present in \code{envir} and custom rows are \emph{not} to be used, that selection is used to define the rows of the submatrix.
All columns are returned in the submatrix unless a multiple column selection is present in \code{envir} and the \code{SelectEffect} in \code{x} is \dQuote{Restrict}, in which case only the selected columns are returned.
}
\author{
Kevin Rue-Albrecht
}
