% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/cleanDataset.R
\name{cleanDataset}
\alias{cleanDataset}
\alias{cleanDataset,SummarizedExperiment-method}
\alias{cleanDataset,SingleCellExperiment-method}
\title{Clean the dataset}
\usage{
cleanDataset(se)

\S4method{cleanDataset}{SummarizedExperiment}(se)

\S4method{cleanDataset}{SingleCellExperiment}(se)
}
\arguments{
\item{se}{A \linkS4class{SummarizedExperiment} object or one of its subclasses.}
}
\value{
A cleaned version of \code{se}.
}
\description{
Clean the SummarizedExperiment by making sure that names of various fields are available and unique.
Also transfer any information stored in \code{rowRanges} into \code{rowData}.
}
\details{
Various \linkS4class{Panel}s assume that the row and column names of the input SummarizedExperiment are available and unique.
This function enforces that, adding consecutive integer names if not available and calling \code{\link{make.unique}} if they are duplicated.

Various \linkS4class{Panel}s further assume that the \code{\link{assay}}, \code{\link{rowData}}, \code{\link{colData}} names are unique;
if this is not the case, \code{\link{selectInput}} behaves in unexpected (and incorrect) ways.
This function enforces that as well by running them through \code{\link{make.unique}}.

Finally, positional information in \code{rowRanges} is not accessible to \code{iSEE}.
This function moves this information into \code{rowData}, prefixing the column names with \code{rowRanges_}.

For \linkS4class{SingleCellExperiment} object, we enforce uniqueness in the \code{\link{reducedDims}}.

All changes result in warnings as a \dQuote{sensible} object is not expected to require any work.
}
\examples{
# Creating a very naughty SE.
se <- SummarizedExperiment(list(cbind(1:10, 2:11), cbind(2:11, 3:12)),
   colData=DataFrame(A=1:2, A=3:4, check.names=FALSE), 
   rowData=DataFrame(B=1:10, B=1:10, check.names=FALSE))
se

cleanDataset(se)
}
\author{
Aaron Lun, Charlotte Soneson
}
