% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{.addMultiSelectionPlotCommands}
\alias{.addMultiSelectionPlotCommands}
\title{Add multiple selection plotting commands}
\usage{
.addMultiSelectionPlotCommands(x, envir, commands, flip = FALSE)
}
\arguments{
\item{x}{An instance of a \linkS4class{DotPlot} class.}

\item{envir}{The environment in which the \link{ggplot} commands are to be evaluated.}

\item{commands}{A character vector representing the sequence of commands to create the \link{ggplot} object.}

\item{flip}{A logical scalar indicating whether the x- and y-axes are flipped,
only relevant to horizontal violin plots.}
}
\value{
A character vector containing \code{commands} plus any additional commands required to draw the self selections.
}
\description{
Add \link{ggplot} instructions to create brushes and lassos for both saved and active multiple selections in a \linkS4class{DotPlot} panel.
}
\details{
This is a utility function that is intended for use in \code{\link{.generateDotPlot}}.
It will modify \code{envir} by adding \code{all_active} and \code{all_saved} variables,
so developers should not use these names for their own variables in \code{envir}.

If no self-selection structures exist in \code{x}, \code{commands} is returned directly without modification.
}
\author{
Aaron Lun
}
