% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family_Panel.R
\name{Panel-class}
\alias{Panel-class}
\alias{initialize,Panel-method}
\alias{[[,Panel-method}
\alias{[[<-,Panel-method}
\alias{[[,Panel,ANY,ANY-method}
\alias{[[<-,Panel,ANY,ANY-method}
\alias{show,Panel-method}
\alias{.defineInterface,Panel-method}
\alias{.refineParameters,Panel-method}
\alias{.cacheCommonInfo,Panel-method}
\alias{.createObservers,Panel-method}
\alias{.hideInterface,Panel-method}
\alias{.defineDataInterface,Panel-method}
\alias{.renderOutput,Panel-method}
\alias{.exportOutput,Panel-method}
\alias{.multiSelectionRestricted,Panel-method}
\alias{.multiSelectionDimension,Panel-method}
\alias{.multiSelectionClear,Panel-method}
\alias{.multiSelectionActive,Panel-method}
\alias{.multiSelectionInvalidated,Panel-method}
\alias{.multiSelectionAvailable,Panel-method}
\alias{.multiSelectionResponsive,Panel-method}
\alias{.isBrushable,Panel-method}
\alias{.singleSelectionDimension,Panel-method}
\alias{.singleSelectionValue,Panel-method}
\alias{.singleSelectionSlots,Panel-method}
\alias{.definePanelTour,Panel-method}
\alias{updateObject,Panel-method}
\title{The Panel virtual class}
\description{
The Panel is a virtual base class for all \pkg{iSEE} panels.
It provides slots and methods to control the height and width of each panel, as well as functionality to control the choice of \dQuote{transmitting} panels from which to receive a multiple row/column selection.
}
\section{Slot overview}{

The following slots are relevant to panel organization:
\itemize{
\item \code{PanelId}, an integer scalar specifying the identifier for the panel.
This should be unique across panels of the same concrete class.
\item \code{PanelWidth}, an integer scalar specifying the width of the panel.
Bootstrap coordinates are used so this value should lie between 2 and 12; defaults to 4 in \code{\link{getPanelDefault}}.
\item \code{PanelHeight}, an integer scalar specifying the height of the panel in pixels.
This is expected to lie between 400 and 1000; defaults to 500 in \code{\link{getPanelDefault}}.
}

The following slots are relevant to \emph{receiving} a multiple selection on the rows:
\itemize{
\item \code{RowSelectionSource}, a string specifying the name of the transmitting panel from which to receive a multiple row selection (e.g., \code{"RowDataPlot1"}).
Defaults to \code{"---"}.
\item \code{RowSelectionDynamicSource}, a logical scalar indicating whether \code{x} should dynamically change its selection source for multiple row selections.
Defaults to \code{FALSE} in \code{\link{getPanelDefault}}.
\item \code{RowSelectionRestrict}, a logical scalar indicating whether the display of \code{x} should be restricted to the rows in the multiple selection received from a transmitting panel.
Defaults to \code{FALSE}.
}

The following slots are relevant to \emph{receiving} a multiple selection on the columns:
\itemize{
\item \code{ColumnSelectionSource}, a string specifying the name of the transmitting panel from which to receive a multiple column selection (e.g., \code{"ColumnDataPlot1"}).
Defaults to \code{"---"}.
\item \code{ColumnSelectionDynamicSource}, a logical scalar indicating whether \code{x} should dynamically change its selection source for multiple column selections.
Defaults to \code{FALSE} in \code{\link{getPanelDefault}}.
\item \code{ColumnSelectionRestrict}, a logical scalar indicating whether the display of \code{x} should be restricted to the columns in the multiple selection received from a transmitting panel.
Defaults to \code{FALSE}.
}

There are also the following miscellaneous slots:
\itemize{
\item \code{SelectionBoxOpen}, a logical scalar indicating whether the selection parameter box should be open at initialization.
Defaults to \code{FALSE}.
\item \code{SelectionHistory}, a list of arbitrary elements that contain parameters for saved multiple selections.
Each element of this list corresponds to one saved selection in the current panel.
Defaults to an empty list.
\item \code{VersionInfo}, a named list of \link{package_version} objects specifying the versions of packages used to create a given \linkS4class{Panel} instance.
This information is used to inform \code{\link{updateObject}} of any updates that need to be applied.
By default, it is filled with a single \code{"iSEE"} entry containing the current version of \pkg{iSEE}.
}
}

\section{Getting and setting slots}{

In all of the following code chunks, \code{x} is an instance of a Panel,
and \code{i} is a string containing the slot name:
\itemize{
\item \code{x[[i]]} returns the value of a slot named \code{i}.
\item \code{x[[i]] <- value} modifies \code{x} so that the value in slot \code{i} is replaced with \code{value}.
\item \code{show(x)} will print a summary of all (non-hidden) slots and their values.
}
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{ColumnDotPlot} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up data values:
\itemize{
\item \code{\link{.refineParameters}(x, se)} calls \code{\link{updateObject}(x)}.
If \code{x} is up to date, this operation is a no-op and returns \code{x} without modification.
\item \code{\link{.cacheCommonInfo}(x, se)} is a no-op, returning \code{se} without modification.
}

For defining the interface:
\itemize{
\item \code{\link{.defineInterface}(x, se, select_info)} will return a list of collapsible boxes for changing data and selection parameters.
The data parameter box will be populated based on \code{\link{.defineDataInterface}}.
\item \code{\link{.defineDataInterface}(x, se, select_info)} will return an empty list.
\item \code{\link{.hideInterface}(x, field)} will always return \code{FALSE}.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} will add observers to respond to changes in multiple selection options.
It will also call \code{\link{.singleSelectionSlots}(x)} to set up observers for responding to transmitted single selections.
\item \code{\link{.renderOutput}(x, se, output, pObjects, rObjects)} will add elements to \code{output} for rendering the information textboxes at the bottom of each panel.
Each panel should specialize this method to add rendering expressions for the actual output (e.g., plots, tables),
followed by a \code{callNextMethod} to create the textboxes.
}

For generating output:
\itemize{
\item \code{\link{.exportOutput}(x, se, all_memory, all_contents)} is a no-op,
i.e., it will return an empty character vector and create no files.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns a data.frame containing the selection-related steps of the tour.
}

For controlling selections:
\itemize{
\item \code{\link{.multiSelectionRestricted}(x)} will always return \code{TRUE}.
\item \code{\link{.multiSelectionDimension}(x)} will always return \code{"none"}.
\item \code{\link{.multiSelectionActive}(x)} will always return \code{NULL}.
\item \code{\link{.multiSelectionClear}(x)} will always return \code{x}.
\item \code{\link{.multiSelectionInvalidated}(x)} will always return \code{FALSE}.
\item \code{\link{.multiSelectionAvailable}(x, contents)} will return \code{nrow(contents)}.
\item \code{\link{.multiSelectionResponsive}(x, dim)} will always return \code{TRUE}.
\item \code{\link{.singleSelectionDimension}(x)} will always return \code{"none"}.
\item \code{\link{.singleSelectionValue}(x)} will always return \code{NULL}.
\item \code{\link{.singleSelectionSlots}(x)} will always return an empty list.
}
}

\section{Subclass expectations}{

Subclasses are required to implement methods for:
\itemize{
\item \code{\link{.defineOutput}}
\item \code{\link{.generateOutput}}
\item \code{\link{.renderOutput}}
\item \code{\link{.fullName}}
\item \code{\link{.panelColor}}
}
Subclasses that transmit selections should also implement specialized methods for selection-related parameters listed above.
}

\seealso{
\linkS4class{DotPlot} and \linkS4class{Table}, for examples of direct subclasses.
}
\author{
Aaron Lun
}
