% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family_DotPlot.R
\name{DotPlot-class}
\alias{DotPlot-class}
\alias{initialize,DotPlot-method}
\alias{updateObject,DotPlot-method}
\alias{.defineOutput,DotPlot-method}
\alias{.generateOutput,DotPlot-method}
\alias{.generateDotPlot,DotPlot-method}
\alias{.renderOutput,DotPlot-method}
\alias{.exportOutput,DotPlot-method}
\alias{.refineParameters,DotPlot-method}
\alias{.cacheCommonInfo,DotPlot-method}
\alias{.createObservers,DotPlot-method}
\alias{.hideInterface,DotPlot-method}
\alias{.multiSelectionActive,DotPlot-method}
\alias{.multiSelectionCommands,DotPlot-method}
\alias{.multiSelectionClear,DotPlot-method}
\alias{.multiSelectionDimension,DotPlot-method}
\alias{.isBrushable,DotPlot-method}
\alias{.singleSelectionValue,DotPlot-method}
\alias{.singleSelectionSlots,DotPlot-method}
\alias{.prioritizeDotPlotData,DotPlot-method}
\alias{.colorByNoneDotPlotField,DotPlot-method}
\alias{.colorByNoneDotPlotScale,DotPlot-method}
\alias{.defineInterface,DotPlot-method}
\alias{.defineVisualColorInterface,DotPlot-method}
\alias{.defineVisualSizeInterface,DotPlot-method}
\alias{.defineVisualShapeInterface,DotPlot-method}
\alias{.defineVisualTextInterface,DotPlot-method}
\alias{.defineVisualPointInterface,DotPlot-method}
\alias{.defineVisualOtherInterface,DotPlot-method}
\alias{.defineVisualFacetInterface,DotPlot-method}
\alias{.allowableColorByDataChoices,DotPlot-method}
\alias{.definePanelTour,DotPlot-method}
\alias{[[,DotPlot-method}
\alias{[[,DotPlot,ANY,ANY-method}
\alias{[[<-,DotPlot-method}
\alias{[[<-,DotPlot,ANY,ANY-method}
\title{The DotPlot virtual class}
\description{
The DotPlot is a virtual class for all panels where each row or column in the \linkS4class{SummarizedExperiment} is represented by no more than one point (i.e., a \dQuote{dot}) in a brushable \link{ggplot} plot.
It provides slots and methods to create the plot, to control various aesthetics of the dots, and to store the brush or lasso selection.
}
\section{Slot overview}{

The following slots are relevant to coloring of the points:
\itemize{
\item \code{ColorBy}, a string specifying how points should be colored.
This should be one of \code{"None"}, \code{"Feature name"}, \code{"Sample name"} and either \code{"Column data"} (for \linkS4class{ColumnDotPlot}s) or \code{"Row data"} (for \linkS4class{RowDotPlot}s).
Defaults to \code{"None"}.
\item \code{ColorByDefaultColor}, a string specifying the default color to use for all points if \code{ColorBy="None"}.
Defaults to \code{"black"} in \code{\link{getPanelDefault}}.
\item \code{ColorByFeatureName}, a string specifying the feature to be used for coloring points when \code{ColorBy="Feature name"}.
For \linkS4class{RowDotPlot}s, this is used to highlight the point corresponding to the selected feature;
for \linkS4class{ColumnDotPlot}s, this is used to color each point according to the expression of that feature.
If \code{NA}, this defaults to the name of the first row.
\item \code{ColorByFeatureSource}, a string specifying the name of the panel to use for transmitting the feature selection to \code{ColorByFeatureName}.
Defaults to \code{"---"}.
\item \code{ColorBySampleName}, a string specifying the sample to be used for coloring points when \code{ColorBy="Sample name"}.
For \linkS4class{RowDotPlot}s, this is used to color each point according to the expression of that sample;
for \linkS4class{ColumnDotPlot}s, this is used to highlight the point corresponding to the selected sample.
If \code{NA}, this defaults to the name of the first column.
\item \code{ColorBySampleSource}, a string specifying the name of the panel to use for transmitting the sample selection to \code{ColorBySampleNameColor}.
Defaults to \code{"---"}.
\item \code{ColorByFeatureDynamicSource}, a logical scalar indicating whether \code{x} should dynamically change its selection source when coloring by feature.
Defaults to \code{FALSE} in \code{\link{getPanelDefault}}.
\item \code{ColorBySampleDynamicSource}, a logical scalar indicating whether \code{x} should dynamically change its selection source when coloring by feature.
Defaults to \code{FALSE} in \code{\link{getPanelDefault}}.
\item \code{SelectionAlpha}, a numeric scalar in [0, 1] specifying the transparency to use for non-selected points.
Defaults to 0.1 in \code{\link{getPanelDefault}}.
}

The following slots control other metadata-related aesthetic aspects of the points:
\itemize{
\item \code{ShapeBy}, a string specifying how the point shape should be determined.
This should be one of \code{"None"} and either \code{"Column data"} (for \linkS4class{ColumnDotPlot}s) or \code{"Row data"} (for \linkS4class{RowDotPlot}s).
Defaults to \code{"None"}.
\item \code{SizeBy}, a string specifying the metadata field for controlling point size.
This should be one of \code{"None"} and either \code{"Column data"} (for \linkS4class{ColumnDotPlot}s) or \code{"Row data"} (for \linkS4class{RowDotPlot}s).
Defaults to \code{"None"}.
}

The following slots control the faceting:
\itemize{
\item \code{FacetRowBy}, a string indicating what to use for creating row facets.
For \linkS4class{RowDotPlot}s, this should be one of \code{"None"}, \code{"Row data"} or \code{"Row selection"}. 
For \linkS4class{ColumnDotPlot}s, this should be one of \code{"None"}, \code{"Column data"} or \code{"Column selection"}. 
Defaults to \code{"None"}, i.e., no row faceting.
\item \code{FacetByColumn}, a string indicating what to use for creating column facets.
For \linkS4class{RowDotPlot}s, this should be one of \code{"None"}, \code{"Row data"} or \code{"Row selection"}. 
For \linkS4class{ColumnDotPlot}s, this should be one of \code{"None"}, \code{"Column data"} or \code{"Column selection"}. 
Defaults to \code{"None"}, i.e., no column faceting.
}

The following slots control any text to be shown on the plot:
\itemize{
\item \code{LabelCenters}, a logical scalar indicating whether the label the centers (technically medoids) of all cells in each group, where groups are defined by a discrete covariate in the relevant metadata field.
Defaults to \code{FALSE}.
\item \code{LabelCentersBy}, a string specifying the metadata field to define the groups when \code{LabelCenters} is \code{TRUE}.
This should be a discrete variable in \code{\link{rowData}} or \code{\link{colData}} for \linkS4class{RowDotPlot}s and \linkS4class{ColumnDotPlot}s, respectively.
Defaults to the name of the first column.
\item \code{LabelCentersColor}, a string specifying the color used for the labels at the center of each group.
Only used when \code{LabelCenters} is \code{TRUE}.
Defaults to \code{"black"}.
\item \code{CustomLabels}, a logical scalar indicating whether custom labels should be inserted on specific points.
Defaults to \code{FALSE}.
\item \code{CustomLabelsText}, a (possibly multi-line) string with the names of the points to label when \code{CustomLabels} is set to \code{TRUE}.
Each line should contain the name of a row or column for \linkS4class{RowDotPlot}s and \linkS4class{ColumnDotPlot}s, respectively.
Leading and trailing whitespace are stripped, and all text on a line after \code{#} is ignored.
Defaults to the name of the first row/column.
}

The following slots control interactions with the plot image:
\itemize{
\item \code{ZoomData}, a named numeric vector of plot coordinates with \code{"xmin"}, \code{"xmax"}, \code{"ymin"} and \code{"ymax"} elements parameterizing the zoom boundaries.
Defaults to an empty vector, i.e., no zoom.
\item \code{BrushData}, a list containing either a Shiny brush (see \code{?\link{brushedPoints}}) or an \pkg{iSEE} lasso (see \code{?\link{lassoPoints}}).
Defaults to an empty list, i.e., no brush or lasso.
\item \code{HoverInfo}, a logical scalar indicating whether the feature/sample name should be shown upon mouse-over of the point.
Defaults to \code{TRUE}.
}

The following slots control some aspects of the user interface:
\itemize{
\item \code{DataBoxOpen}, a logical scalar indicating whether the data parameter box should be open.
Defaults to \code{FALSE}.
\item \code{VisualBoxOpen}, a logical scalar indicating whether the visual parameter box should be open.
Defaults to \code{FALSE}.
\item \code{VisualChoices}, a character vector specifying the visible interface elements upon initialization.
This can contain zero or more of \code{"Color"}, \code{"Shape"}, \code{"Size"}, \code{"Point"} , \code{"Facet"}, \code{"Text"}, and \code{"Other"}.
Defaults to \code{"Color"}.
}

The following slots control the addition of a contour:
\itemize{
\item \code{ContourAdd}, logical scalar indicating whether a contour should be added to a (scatter) plot.
Defaults to \code{FALSE}.
\item \code{ContourColor}, string specifying the color to use for the contour lines.
Defaults to \code{"blue"}.
}

The following slot controls whether the aspect ratio is fixed to 1 or not:
\itemize{
\item \code{FixAspectRatio}, logical scalar indicating whether the aspect ratio of a scatter plot should be fixed to 1. 
Defaults to \code{FALSE}.
}

The following slot controls whether the violin boundaries are plotted or not:
\itemize{
\item \code{ViolinAdd}, logical scalar indicating whether the violin boundaries should be plotted. 
Defaults to \code{TRUE}.
}

The following slots control the general appearance of the points.
\itemize{
\item \code{PointSize}, positive numeric scalar specifying the relative size of the points.
Defaults to 1.
\item \code{PointAlpha}, non-negative numeric scalar specifying the transparency of the points.
Defaults to 1, i.e., not transparent.
\item \code{Downsample}, logical scalar indicating whether to downsample points for faster plotting.
Defaults to \code{FALSE} in \code{\link{getPanelDefault}}.
\item \code{DownsampleResolution}, numeric scalar specifying the resolution of the downsampling grid (see \code{?\link{subsetPointsByGrid}}) if \code{Downsample=TRUE}.
Larger values correspond to reduced downsampling at the cost of plotting speed.
Defaults to 200 in \code{\link{getPanelDefault}}.
}

The following slots refer to general plotting parameters:
\itemize{
\item \code{FontSize}, positive numeric scalar specifying the relative font size.
Defaults to 1 in \code{\link{getPanelDefault}}.
\item \code{PointSize}, positive numeric scalar specifying the relative point size.
Defaults to 1 in \code{\link{getPanelDefault}}.
\item \code{LegendPosition}, string specifying the position of the legend on the plot.
Defaults to \code{"Bottom"} in \code{\link{getPanelDefault}}.
Other valid choices include \code{"Right"} and \code{"None"}.
}

In addition, this class inherits all slots from its parent \linkS4class{Panel} class.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{DotPlot} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up the objects:
\itemize{
\item \code{\link{.cacheCommonInfo}(x)} adds a \code{"DotPlot"} entry containing \code{valid.assay.names}, a character vector of valid assay names.
Valid names are defined as those that are non-empty, i.e., not \code{""}.
This method will also call the equivalent \linkS4class{Panel} method.
\item \code{\link{.refineParameters}(x, se)} replaces \code{NA} values in \code{ColorByFeatureName} and \code{ColorBySampleNameColor} with the first row and column name, respectively, of \code{se}.
This will also call the equivalent \linkS4class{Panel} method.
}

For defining the interface:
\itemize{
\item \code{\link{.defineInterface}(x, se, select_info)} defines the user interface for manipulating all slots described above and in the parent classes.
It will also create a data parameter box that can respond to specialized \code{\link{.defineDataInterface}}.
This will \emph{override} the \linkS4class{Panel} method.
\item \code{\link{.defineVisualColorInterface}(x, se, select_info)} defines the user interface subpanel for manipulating the color of the points.
\item \code{\link{.defineVisualShapeInterface}(x, se)} defines the user interface subpanel for manipulating the shape of the points.
\item \code{\link{.defineVisualSizeInterface}(x, se)} defines the user interface subpanel for manipulating the size of the points.
\item \code{\link{.defineVisualPointInterface}(x, se)} defines the user interface subpanel for manipulating other point-related parameters.
\item \code{\link{.defineVisualFacetInterface}(x, se)} defines the user interface subpanel for manipulating facet-related parameters.
\item \code{\link{.defineVisualTextInterface}(x, se)} defines the user interface subpanel for manipulating text-related parameters.
\item \code{\link{.defineVisualOtherInterface}(x, se)} defines the user interface subpanel for manipulating other parameters.
Currently this returns \code{NULL}.
\item \code{\link{.defineOutput}(x)} returns a UI element for a brushable plot.
\item \code{\link{.allowableColorByDataChoices}(x, se)} returns a character vector containing all atomic variables in the relevant \code{*Data} dimension.
}

For generating the output:
\itemize{
\item \code{\link{.generateOutput}(x, se, all_memory, all_contents)} returns a list containing \code{contents}, a data.frame with one row per point currently present in the plot;
\code{plot}, a \link{ggplot} object;
\code{commands}, a list of character vector containing the R commands required to generate \code{contents} and \code{plot};
and \code{varname}, a string containing the name of the variable in \code{commands} that was used to obtain \code{contents}.
\item \code{\link{.generateDotPlot}(x, labels, envir)} returns a list containing \code{plot} and \code{commands}, as described above.
This is called within \code{\link{.generateOutput}} for all \linkS4class{DotPlot} instances by default.
Methods are also guaranteed to generate a \code{dot.plot} variable in \code{envir} containing the \link{ggplot} object corresponding to \code{plot}.
\item \code{\link{.prioritizeDotPlotData}(x, envir)} returns \code{NULL}.
\item \code{\link{.colorByNoneDotPlotField}(x)} returns \code{NULL}.
\item \code{\link{.colorByNoneDotPlotScale}(x)} returns \code{NULL}.
\item \code{\link{.exportOutput}(x, se, all_memory, all_contents)} will create a PDF file containing the current plot, and return a string containing the path to that PDF.
This assumes that the \code{plot} field returned by \code{\link{.generateOutput}} is a \link{ggplot} object.
}

For defining reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for some (but not all!) of the slots.
This will also call the equivalent \linkS4class{Panel} method.
\item \code{\link{.renderOutput}(x, se, output, pObjects, rObjects)} will add a rendered plot element to \code{output}.
The reactive expression will add the contents of the plot to \code{pObjects$contents} and the relevant commands to \code{pObjects$commands}.
This will also call the equivalent \linkS4class{Panel} method to render the panel information text boxes.
}

For controlling selections:
\itemize{
\item \code{\link{.multiSelectionCommands}(x, index)} returns a character vector of R expressions that - when evaluated - returns a character vector of the names of selected points in the active and/or saved selections of \code{x}.
The active selection is returned if \code{index=NA}, otherwise one of the saved selection is returned.
\item \code{\link{.multiSelectionActive}(x)} returns \code{x[["BrushData"]]} or \code{NULL} if there is no brush or closed lasso.
\item \code{\link{.multiSelectionClear}(x)} returns \code{x} after setting the \code{BrushData} slot to an empty list.
\item \code{\link{.singleSelectionValue}(x, contents)} returns the name of the first selected element in the active brush.
If no brush is active, \code{NULL} is returned instead.
\item \code{\link{.singleSelectionSlots}(x)} will return a list specifying the slots that can be updated by single selections in transmitter panels, mostly related to the choice of coloring parameters.
This includes the output of \code{callNextMethod}.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing the steps of a tour relevant to subclasses,
mostly describing the specification of visual effects and the creation of a brush or lasso.
}

Unless explicitly specialized above, all methods from the parent class \linkS4class{Panel} are also available.
}

\section{Subclass expectations}{

The DotPlot is a rather vaguely defined class for which the only purpose is to avoid duplicating code for \linkS4class{ColumnDotPlot}s and \linkS4class{RowDotPlot}s.
We recommend extending those subclasses instead.
}

\seealso{
\linkS4class{RowDotPlot} and \linkS4class{ColumnDotPlot}, which are more amenable to extension.
}
\author{
Aaron Lun
}
