% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{roc}
\alias{roc}
\alias{roc<-}
\alias{roc,COBRAPerformance-method}
\alias{roc<-,COBRAPerformance,data.frame-method}
\alias{roc,COBRAPlot-method}
\alias{roc<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{roc} slot}
\usage{
roc(x, ...)

roc(x, ...) <- value

\S4method{roc}{COBRAPerformance}(x)

\S4method{roc}{COBRAPerformance,data.frame}(x) <- value

\S4method{roc}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information necessary to generate ROC curves
for each method and each stratification level.}
}
\value{
The accessor function returns a data frame giving information
  necessary to generate ROC curves for each method and each stratification
  level.
}
\description{
Accessor and replacement functions for the \code{roc} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status", aspects = "roc")
head(roc(cobraperf))
}
\author{
Charlotte Soneson
}
