% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_performance.R
\name{reorder_levels}
\alias{reorder_levels}
\title{Reorder levels in COBRAPlot object}
\usage{
reorder_levels(cobraplot, levels)
}
\arguments{
\item{cobraplot}{A COBRAPlot object}

\item{levels}{A character vector giving the order of the levels. Any values
not present in the COBRAPlot object will be removed. Any methods present in
the COBRAPlot object but not contained in this vector will be added at the
end.}
}
\value{
A COBRAPlot object
}
\description{
Reorder levels in COBRAPlot object to achieve desired ordering in figure
legends etc. If facetted(cobraplot) is TRUE, the releveling will be applied
to the "method" column. If facetted(cobraplot) is FALSE, it will be applied
to the "fullmethod" column.
}
\examples{
data(cobradata_example_sval)
cobraperf <- calculate_performance(cobradata_example_sval,
                                   binary_truth = "status", aspects = "fpr")
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
cobraplot <- reorder_levels(cobraplot, c("Method2", "Method1"))

}
\author{
Charlotte Soneson
}
