% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_tpr}
\alias{plot_tpr}
\title{Plot TPR}
\usage{
plot_tpr(
  cobraplot,
  title = "",
  stripsize = 15,
  titlecol = "black",
  pointsize = 5,
  xaxisrange = c(0, 1)
)
}
\arguments{
\item{cobraplot}{A \code{COBRAPlot} object.}

\item{title}{A character string giving the title of the plot.}

\item{stripsize}{A numeric value giving the size of the strip text, when the
results are stratified by an annotation.}

\item{titlecol}{A character string giving the color of the title.}

\item{pointsize}{A numeric value giving the size of the plot characters.}

\item{xaxisrange}{A numeric vector with two elements, giving the lower and
upper boundary of the x-axis, respectively.}
}
\value{
A ggplot object
}
\description{
Plot observed true positive rate (TPR) for given adjusted p-value thresholds.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status", aspects = "tpr")
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
plot_tpr(cobraplot)
}
\author{
Charlotte Soneson
}
