% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_roc}
\alias{plot_roc}
\title{Plot ROC curves}
\usage{
plot_roc(
  cobraplot,
  title = "",
  stripsize = 15,
  titlecol = "black",
  xaxisrange = c(0, 1),
  yaxisrange = c(0, 1),
  linewidth = 1
)
}
\arguments{
\item{cobraplot}{A \code{COBRAPlot} object.}

\item{title}{A character string giving the title of the plot.}

\item{stripsize}{A numeric value giving the size of the strip text, when the
results are stratified by an annotation.}

\item{titlecol}{A character string giving the color of the title.}

\item{xaxisrange}{A numeric vector with two elements, giving the lower and
upper boundary of the x-axis, respectively.}

\item{yaxisrange}{A numeric vector with two elements, giving the lower and
upper boundary of the y-axis, respectively.}

\item{linewidth}{The line width used for plotting}
}
\value{
A ggplot object
}
\description{
Plot receiver operating characteristics (ROC) curves.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status", aspects = "roc")
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
plot_roc(cobraplot)
}
\author{
Charlotte Soneson
}
