% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_deviation}
\alias{plot_deviation}
\title{Plot deviations}
\usage{
plot_deviation(
  cobraplot,
  title = "",
  stripsize = 15,
  titlecol = "black",
  xaxisrange = NULL,
  plottype = "boxplot",
  dojitter = TRUE,
  transf = "raw"
)
}
\arguments{
\item{cobraplot}{A \code{COBRAPlot} object.}

\item{title}{A character string giving the title of the plot.}

\item{stripsize}{A numeric value giving the size of the strip text, when the
results are stratified by an annotation.}

\item{titlecol}{A character string giving the color of the title.}

\item{xaxisrange}{A numeric vector with two elements, giving the lower and
upper boundary of the x-axis, respectively.}

\item{plottype}{Either "boxplot" or "violinplot", indicating what type of
plot to make.}

\item{dojitter}{A logical indicating whether to include jittered data points
or not.}

\item{transf}{A character indicating the transformation to apply to the
deviations before plotting. Must be one of "raw", "absolute" or "squared"}
}
\value{
A ggplot object
}
\description{
Plot the deviations between observed scores and the continuous truth
variable.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example, cont_truth = "logFC",
                                   aspects = "deviation")
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
plot_deviation(cobraplot)
}
\author{
Charlotte Soneson
}
