% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{onlyshared}
\alias{onlyshared}
\alias{onlyshared<-}
\alias{onlyshared,COBRAPerformance-method}
\alias{onlyshared<-,COBRAPerformance,logical-method}
\alias{onlyshared,COBRAPlot-method}
\alias{onlyshared<-,COBRAPlot,logical-method}
\title{Accessor and replacement functions for \code{onlyshared} slot}
\usage{
onlyshared(x, ...)

onlyshared(x, ...) <- value

\S4method{onlyshared}{COBRAPerformance}(x)

\S4method{onlyshared}{COBRAPerformance,logical}(x) <- value

\S4method{onlyshared}{COBRAPlot,logical}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A logical indicating whether only features that are shared
between result and truth are retained, or if all features in the truth are
used.}
}
\value{
The accessor function returns a logical indicating whether only
  features that are shared between result and truth are retained, or if all
  features in the truth are used.
}
\description{
Accessor and replacement functions for the \code{onlyshared} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrtpr")
head(onlyshared(cobraperf))
}
\author{
Charlotte Soneson
}
