% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{fsrnbrcurve}
\alias{fsrnbrcurve}
\alias{fsrnbrcurve<-}
\alias{fsrnbrcurve,COBRAPerformance-method}
\alias{fsrnbrcurve<-,COBRAPerformance,data.frame-method}
\alias{fsrnbrcurve,COBRAPlot-method}
\alias{fsrnbrcurve<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{fsrnbrcurve} slot}
\usage{
fsrnbrcurve(x, ...)

fsrnbrcurve(x, ...) <- value

\S4method{fsrnbrcurve}{COBRAPerformance}(x)

\S4method{fsrnbrcurve}{COBRAPerformance,data.frame}(x) <- value

\S4method{fsrnbrcurve}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information necessary to generate curves of 
observed FSR vs number of features called positive for each method and each
stratification level. If the object does not have an fsrnbrcurve slot
(older versions of the class did not have this slot), an empty data frame
is returned for simplicity.}
}
\value{
The accessor function returns a data frame giving information
  necessary to generate curves of observed FSR vs number of features called
  positive for each method and each stratification level.
}
\description{
Accessor and replacement functions for the \code{fsrnbrcurve} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
cobradata <- cobradata_example_sval

cobraperf <- calculate_performance(cobradata, 
                                   cont_truth = "logFC", 
                                   aspects = "fsrnbrcurve")
head(fsrnbrcurve(cobraperf))
}
\author{
Charlotte Soneson
}
