% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COBRAData.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{Extract}
\alias{Extract}
\alias{\S4method{[}{COBRAData,ANY,ANY}}
\alias{\S4method{[}{COBRAData,ANY,ANY,ANY}}
\alias{[}
\alias{[,COBRAData-method}
\alias{[,COBRAPerformance-method}
\alias{\S4method{[}{COBRAPerformance,ANY,ANY}}
\alias{\S4method{[}{COBRAPerformance,ANY,ANY,ANY}}
\alias{[,COBRAPlot-method}
\alias{\S4method{[}{COBRAPlot,ANY,ANY}}
\alias{\S4method{[}{COBRAPlot,ANY,ANY,ANY}}
\title{Subsetting \code{COBRAData}, \code{COBRAPerformance} or \code{COBRAPlot}
objects}
\usage{
\S4method{[}{COBRAData,ANY,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[}{COBRAPerformance,ANY,ANY,ANY}(x, i = "missing", j, drop = "missing")

\S4method{[}{COBRAPlot,ANY,ANY,ANY}(x, i = "missing", j, drop = "missing")
}
\arguments{
\item{x}{A \code{COBRAData}, \code{COBRAPerformance} or \code{COBRAPlot}
object.}

\item{i}{For \code{COBRAData} objects, a character vector of feature names to
retain.}

\item{j}{For \code{COBRAPerformance} and \code{COBRAPlot} objects, a
character vector with method names to retain.}

\item{drop}{not used.}
}
\value{
A subset of the original object, of the same class
}
\description{
Functions to subset \code{COBRAData}, \code{COBRAPerformance} or
\code{COBRAPlot} objects. \code{COBRAData} objects are subset by features
(rows), while \code{COBRAPerformance} and \code{COBRAPlot} objects are subset
by methods (columns). Numeric indices are not allowed, since not all slots
may be arranged in the same order.
}
\examples{
data(cobradata_example)
cobradata_example[c("ENSG00000000457", "ENSG00000000971",
                    "ENSG00000000460"), ]
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrtpr")
cobraperf[, c("voom")]
cobraplot <- prepare_data_for_plot(cobraperf)
cobraplot[, c("voom")]
}
