% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tissue.R
\name{plotTissue}
\alias{plotTissue}
\title{Plot cells based on cell position on tissue.}
\usage{
plotTissue(
  spe,
  targetcell = FALSE,
  k_near = 100,
  targetsize = 3,
  targetshape = 1,
  targetcolor = "red",
  scaleFactor = 1,
  reverseY = TRUE,
  ...
)
}
\arguments{
\item{spe}{SpatialExperiment object.}

\item{targetcell}{Optional. Can input ONE specific cell id to zoom-in on
the region of a specific cell.}

\item{k_near}{Optional. If targetcell is specified, the k_near cells around
the targetcell will be plotted.}

\item{targetsize}{Dot size of the targetcell.}

\item{targetshape}{Shape of the targetcell.}

\item{targetcolor}{Colour of the targetcell.}

\item{scaleFactor}{Scale factor to align with the image.}

\item{reverseY}{Reverse y coordinates.}

\item{...}{aesthetic mappings to pass to \code{ggplot2::aes_string()}.}
}
\value{
A ggplot object.
}
\description{
Plot cells based on cell position on tissue.
}
\examples{

data("spe_test")

plotTissue(spe, color = celltypes)

}
