% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_pm_spe.R
\name{mergeHoodSpe}
\alias{mergeHoodSpe}
\title{Merge probability matrix into SpatialExperiment object.}
\usage{
mergeHoodSpe(spe, pm, val_names = NULL)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{pm}{Probability matrix. Can be obtained by the function mergeByGroup.}

\item{val_names}{Character vector with length of the ncol of pm.}
}
\value{
A SpatialExperiment object. Cell-level neighborhood information are
saved in the colData of the SpatialExperiment object.
}
\description{
Merge probability matrix into SpatialExperiment object.
}
\examples{

data("spe_test")

spe <- readHoodData(spe, anno_col = "celltypes")

fnc <- findNearCells(spe, k = 100)

pm <- scanHoods(fnc$distance)

pm2 <- mergeByGroup(pm, fnc$cells)

spe <- mergeHoodSpe(spe, pm2)

}
