% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/test.hierarchy.R
\name{test.hierarchy}
\alias{test.hierarchy}
\title{Hierarchical Testing of SNPs}
\usage{
test.hierarchy(x, y, dendr, res.multisplit, covar = NULL, SNP_index = NULL,
  alpha = 0.05, global.test = TRUE, verbose = TRUE)
}
\arguments{
\item{x}{The input matrix, of dimension \code{nobs x nvar}. Each row
represents a subject, each column a SNP.}

\item{y}{The response vector. It can be continuous or discrete.}

\item{dendr}{The cluster tree obtained by hierchically clustering the SNPs
using \code{cluster.snp}.}

\item{res.multisplit}{The output of \code{multisplit}.}

\item{covar}{\code{NULL} or the matrix of covariates one wishes to control
for, of size \code{nobs x ncovar}.}

\item{SNP_index}{\code{NULL} or the index vector of SNP to be tested. See
the 'Details' section.}

\item{alpha}{The significance level at which the FWER is controlled. Default
value is 0.05.}

\item{global.test}{Specifies wether the global null hypothesis should be
tested. Default value is \code{TRUE}. See the 'Details' section.}

\item{verbose}{Report information on progress. Default value is \code{TRUE}}
}
\value{
A list of significant SNP groups with the following components:
\item{SNP_index}{The indeces of the SNPs in the group}
\item{pval}{The p-value of the SNP group}
}
\description{
Performs hierarchical testing of SNPs.
}
\details{
The testing is performed on the cluster tree given by \code{dendr}.
If the SNP data matrix was divided (e.g. by chromosome), and clustered
separately, the user must provide the argument \code{SNP_index}, to specify
which part of the data is being tested.

Testing starts at the highest level, which includes all variables specified
by \code{SNP_index}, and moves down the cluster tree. It stops when a cluster's
null hypothesis cannot be rejected anymore. The smallest, still significant
clusters will be returned.

By default the parameter \code{global.test = TRUE}, which means that first
the global null hypothesis is tested. If the data is divided (e.g. by
chromosome), and clustered separately, this parameter can be set to
\code{FALSE} once the global null has been rejected. This helps save time.
}
\examples{
library(MASS)
x <- mvrnorm(60,mu = rep(0,60), Sigma = diag(60))
beta <- rep(0,60)
beta[c(5,9,3)] <- 1
y <- x \%*\% beta + rnorm(60)
dendr <- cluster.snp(x = x, method = "average")
res.multisplit <- multisplit(x, y)
sign.clusters <- test.hierarchy(x, y, dendr, res.multisplit)
}
\references{
Buzdugan, L. et al. (2015), Assessing statistical significance in
predictive genome-wide association studies
}

