% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermesData-methods.R
\name{lapply,MultiAssayExperiment-method}
\alias{lapply,MultiAssayExperiment-method}
\alias{lapply}
\title{\code{lapply} method for \code{MultiAssayExperiment}}
\usage{
\S4method{lapply}{MultiAssayExperiment}(X, FUN, safe = TRUE, ...)
}
\arguments{
\item{X}{(\code{MultiAssayExperiment})\cr input.}

\item{FUN}{(\code{function}) to be applied to each experiment in \code{X}.}

\item{safe}{(\code{flag})\cr whether this method should skip experiments
where the function fails.}

\item{...}{additional arguments passed to \code{FUN}.}
}
\value{
\code{MultiAssayExperiment} object with specified function applied.
}
\description{
Apply a function on all experiments in an MAE.
}
\examples{
object <- multi_assay_experiment
result <- lapply(object, normalize, safe = TRUE)
# Similarly, all experiments in an MAE can be converted to HermesData class:
result <- lapply(object, HermesData, safe = TRUE)
}
