% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotHeatmapList.R
\name{plot_legend}
\alias{plot_legend}
\title{Plot a color legend for a heatmap}
\usage{
plot_legend(scale, options)
}
\arguments{
\item{scale}{Numeric vector contain min and max for the scale}

\item{options}{heatmapOptions passed as a list

This function plots a vertical color scale (or legend). With the default parameters,
it looks good at about 1/5 the width of a heatmap, about 1cm x 10cm. This
function only plots the legend, it does not set margin parameters.}
}
\value{
invisible(0)
}
\description{
Plot a color legend for a heatmap
}
\examples{
data(HeatmapExamples)
opts = heatmapOptions()
opts$color = "Rainbow"
par(mai=opts$legend.mai)
plot_legend(c(0,1), opts)
}
\seealso{
plotHeatmapList
}
