% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPatternDensityMap.R
\docType{methods}
\name{plotPatternDensityMap}
\alias{plotPatternDensityMap}
\alias{plotPatternDensityMap,DNAStringSet-method}
\title{Plot heatmaps for several patterns in DNA sequence}
\usage{
plotPatternDensityMap(seq, patterns, ...)

\S4method{plotPatternDensityMap}{DNAStringSet}(seq, patterns, coords = NULL,
  min.score = "80\%", sigma = c(3, 3), output.size = NULL,
  options = NULL, ...)
}
\arguments{
\item{seq}{DNAStringSet of equal width}

\item{patterns}{A vector or list of patterns}

\item{...}{Additional Heatmap plotting options

This function is a convenient wrapper for plotting many different patterns
for the same set of sequences. PatternHeatmap() is applied to the sequence
for each pattern in the list, they are passed to smoothHeatmap() with the supplied
parameters and finally PlotHeatmapList().

If fine-grained control is desired, or you want to mix other plot types, then
more information is available in the vignette.}

\item{coords}{Heatmap coords}

\item{min.score}{Minimum score for PWM match}

\item{sigma}{Bandwith for smoothing kernel}

\item{output.size}{Output size of final image}

\item{options}{Heatmap plotting options}
}
\value{
invisible(0)
}
\description{
Plot heatmaps for several patterns in DNA sequence
}
\section{Methods (by class)}{
\itemize{
\item \code{DNAStringSet}: Plot heatmaps for several patterns in DNA sequence
}}

\examples{
data(HeatmapExamples)
plotPatternDensityMap(string_set, c("AT", "CG"), coords=c(-200, 200))
}
\seealso{
PatternHeatmap plotHeatmapList smoothHeatmap
}
