% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdxincoperationFourier.R
\name{fourierIsotope}
\alias{fourierIsotope}
\title{fourier transform approach to computing isotopic distribution}
\usage{
fourierIsotope(
  elements,
  incorp = 0,
  num_exch_sites = 0,
  charge = 1,
  isotopes = NULL
)
}
\arguments{
\item{elements}{A list of elements}

\item{incorp}{The deuterium incoperation}

\item{num_exch_sites}{The number of exchangable amides. Default is 0.}

\item{charge}{The charge state of the peptide}

\item{isotopes}{The number of isotopes to compute. The default is NULL, in whiich
a default heuristic is used to make a good guess that covers the expected peaks.}
}
\value{
A list of mass and intensity value corresponding to the isotope distribution
}
\description{
fourier transform approach to computing isotopic distribution
}
\examples{
fourierIsotope(c(C = 0, H = 2, N = 0, O = 1, S = 0, P = 0))

}
\author{
Oliver Crook
}
