% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdxmsqc-utils.R
\name{computeMassError}
\alias{computeMassError}
\title{Empirical versus theoretical mass errors}
\usage{
computeMassError(object, eCentroid = "Exp.Cent", tCentroid = "Theor.Cent")
}
\arguments{
\item{object}{An object of class \code{QFeatures}}

\item{eCentroid}{character string indicating column identifier for
experimental centroid}

\item{tCentroid}{character string indicating column identifier for
theoretical centroid}
}
\value{
The error difference between the empirical and theoretical centroid
}
\description{
Empirical versus theoretical mass errors
}
\examples{
data("BRD4df")
result <- computeMassError(BRD4df, "Exp.Cent", "Theor.Cent")
head(result)
}
\author{
Oliver Crook
}
