% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pausingIndex.R
\name{pausingIndex}
\alias{pausingIndex}
\title{Returns the pausing index for different genes.  TODO: DESCRIBE THE PAUSING
INDEX.}
\usage{
pausingIndex(
  features,
  reads,
  size = 50,
  up = 1000,
  down = 1000,
  UnMAQ = NULL,
  debug = FALSE,
  ...
)
}
\arguments{
\item{features}{A GRanges object representing a set of genomic coordinates.}

\item{reads}{A GRanges object representing a set of mapped reads.}

\item{size}{The size of the moving window.}

\item{up}{Distance upstream of each f to align and histogram.}

\item{down}{Distance downstream of each f to align and histogram (NULL).}

\item{UnMAQ}{Data structure representing the coordinates of all un-mappable
regions in the genome.}

\item{debug}{If set to TRUE, provides additional print options.  Default:
FALSE}

\item{...}{Extra argument passed to mclapply}
}
\value{
Returns a data.frame of the pausing indices for the input genes.

Returns the pausing index for different genes.
}
\description{
Supports parallel processing using mclapply in the 'parallel' package.
To change the number of processors, use the argument 'mc.cores'.
}
\examples{
features <- GRanges("chr7", IRanges(2394474,2420377), strand="+")
reads <- as(readGAlignments(system.file("extdata", "S0mR1.bam",
            package="groHMM")), "GRanges")
## Not run:
# pi <- pausingIndex(features, reads)
}
\author{
Charles G. Danko and Minho Chae.
}
