% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmoviz.R
\name{gmovizPlot}
\alias{gmovizPlot}
\title{Generate an entire circular plot}
\usage{
gmovizPlot(file_name, file_type = "png", plotting_functions,
  legends = NULL, title = NULL, width = 338.7, height = 238.7,
  units = "mm", res = 300, background_colour = "transparent",
  title_x_position = 0.5, title_y_position = 0.9,
  title_font_face = "bold", title_size = 1.1, title_colour = "black",
  point_size = 11)
}
\arguments{
\item{file_name}{The name of the file to be saved.}

\item{file_type}{The type of image file to produce: either \code{'png'},
\code{'svg'} or \code{'ps'}.}

\item{plotting_functions}{The functions you want to plot (e.g.
\code{\link{insertionDiagram}} or \code{\link{gmovizInitialise}}).}

\item{legends}{A legend object to plot, generated by
\code{\link{makeLegends}}.}

\item{title}{Text for the title, leave as \code{NULL} for no title.}

\item{width}{Width of the image.}

\item{height}{Height of the image.}

\item{units}{Units for the width and height of the image. One of
\code{'mm'}, \code{'cm'} or \code{'in'} (inches).}

\item{res}{Resolution of the image (only needed for .png files).}

\item{background_colour}{Colour of the image background.}

\item{title_x_position, title_y_position}{X and Y positions of the title on
the image.}

\item{title_font_face}{Font face of the title: bold, italic or bold-italic.}

\item{title_size}{Size of the title.}

\item{title_colour}{Colour of the title.}

\item{point_size}{Pointsize (for postscript output only).}
}
\value{
Saves a plot to disk in the specified format.
}
\description{
Saves code supplied to \code{plotting_functions} a plot (with
optional title and legends) as either .png, .svg or .ps.
}
\examples{
## make some example data
small_ideogram <- data.frame(chr=c('region 1', 'region 2', 'region 3'),
start=c(0, 0, 0), end=c(10000, 12000, 10000))
small_plot_data <- data.frame(
chr=sample(c('region 1', 'region 2', 'region 3'), size=40, replace=TRUE),
start=sample(0:10000, 40), end=sample(0:10000, 40),
val=rnorm(40, 2, 0.5))

## plot it
\dontrun{
gmovizPlot('test.png', {
gmovizInitialise(small_ideogram, custom_sector_width=c(0.3, 0.3, 0.3))
drawScatterplotTrack(small_plot_data)}, title='scatterplot')}
}
\seealso{
\code{\link{makeLegends}} for a function that generates the legend
objects.
}
