% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmoviz.R
\name{gmovizInitialise}
\alias{gmovizInitialise}
\title{Initialise the layout of the circular plot}
\usage{
gmovizInitialise(ideogram_data, start_degree = 90,
  space_between_sectors = 1, zoom_sectors = NULL, zoom_size = 0.055,
  remove_unzoomed = TRUE, zoom_prefix = "zoomed_",
  custom_sector_width = NULL, track_height = 0.1,
  sector_colours = nice_colours, sector_border_colours = nice_colours,
  coverage_rectangle = NULL, coverage_data = NULL,
  custom_ylim = NULL, sector_labels = TRUE, sector_label_size = 0.9,
  sector_label_colour = "black", xaxis = TRUE,
  xaxis_orientation = "top", xaxis_label_size = 0.75,
  xaxis_colour = "#747577", xaxis_spacing = 10,
  xaxis_spacing_unit = "deg", label_data = NULL,
  label_colour = "black", label_size = 0.85,
  space_between_labels = 0.4, label_orientation = "outside",
  sort_sectors = TRUE)
}
\arguments{
\item{ideogram_data}{Either a \linkS4class{GRanges} representing regions of
interest or a data frame in bed format (containing the \code{chr},
\code{start} and \code{end} columns). If you want to read in data from file,
please see the \code{\link{getIdeogramData}} function.}

\item{start_degree}{Where on the circle the first sector will start being
drawn from (90 = 12 o'clock).}

\item{space_between_sectors}{Space between each sector.}

\item{zoom_sectors}{A character vector of sectors that should be 'zoomed'
(made bigger than usual, useful to show shorter sequences like plasmids
alongside longer sequences like chromosomes).}

\item{zoom_size}{The size of the zoomed chromosome, as a proportion of the
entire circle (0 = invisible, 1 = entire circle filled). The default value
of \code{0.055} is good for displaying something small (e.g. plasmid)
alongside something large (e.g. chromosomes).}

\item{remove_unzoomed}{If \code{TRUE}, the sectors in \code{zoom_sectors}
will only appear in their zoomed form. If \code{FALSE}, both the zoomed
and unzoomed versions will be plotted.}

\item{zoom_prefix}{A character prefix that will be applied to zoomed
sequences to distinguish them from non-zoomed ones.}

\item{custom_sector_width}{Normally, the size of each sector is proportional
to its relative length, but \code{custom_sector_width} can change this. It
is a vector of sector sizes (as proportions of the entire circle), given in
the same order in which sectors are plotted: firstly 'chr1', 'chr2' ...
through to 'chrX' and 'chrY' followed by any differently named sectors e.g.
'gene 1', plasmid' in alphabetical order.}

\item{track_height}{The height (vertical distance around the circle) that
will be taken up by this track. Should be a number between 0 (none) and 1
(entire circle).}

\item{sector_colours}{Either a single colour (which will be applied to all
sectors) or a vector with the same length as the number of sectors/regions.
This package includes 5 colour sets: \code{nice_colours},
\code{pastel_colours}, \code{bright_colours_transparent},
\code{bright_colours_opaque} and \code{rich_colours}. See
\code{\link{colourSets}} for more information about these.}

\item{sector_border_colours}{Same as \code{sector_colours}, only for the
border of each sector.}

\item{coverage_rectangle}{A vector containing the name(s) of any sector(s)
that you would like to depict as 'coverage rectangles': filled in shapes
that are a plot of the coverage data over that sector. See the example below
or the vignette for an example of this.}

\item{coverage_data}{A GRanges (or data frame) containing the coverage data
to plot for those sectors in \code{coverage_rectangle}. To read this data in
from a BAM file, please see the \code{\link{getCoverage}} function.}

\item{custom_ylim}{A vector of length two containing the y (coverage) axis
limits. No need to set if not using coverage rectangles or if you're happy
with the default: c(0, maximum coverage).}

\item{sector_labels}{If \code{TRUE}, labels ('chr1', 'chr2' etc.) will be
drawn for each sector (recommended).}

\item{sector_label_size}{Size of the sector labels.}

\item{sector_label_colour}{Colour of the sector labels.}

\item{xaxis}{If \code{TRUE}, an x (genomic position) xaxis  will be plotted.}

\item{xaxis_orientation}{Either \code{'top'} to put the x axis on the
outside of the circle or \code{'bottom'} to put it on the inside.}

\item{xaxis_label_size}{Size of the x axis labels.}

\item{xaxis_colour}{Colour of the x axis labels.}

\item{xaxis_spacing}{Space between the x axis labels, in degrees.
Alternatively, the string 'start_end' will place a label at the start and
end of each sector only.}

\item{xaxis_spacing_unit}{Either \code{"deg"} to draw ticks every certain
number of degrees around the circle or \code{"bp"} to draw ticks every
certain bp around the circle (be warned that when the scales for each sector
are very different, it's best to use \code{"deg"})}

\item{label_data}{Data frame or \linkS4class{GRanges} containing the
labels. If a GRanges, \code{label} should be a metadata column containing
the character strings of the labels. \code{type} and \code{colour} can also
be used to store additional information about the type (e.g. 'gene' or
'promoter') and colour of the label. This information can be used to
\bold{colour code} the labels by supplying the colour column as the
\code{label_colour} parameter. Data frames should additionally include the
\code{chr}, \code{start}, \code{end} which dictate the position of the
label.}

\item{label_colour}{Colour of the labels, can be either a single value
(applied to all labels) or a vector with the same length as the number of
labels (for colour-coding).}

\item{label_size}{Size of the labels.}

\item{space_between_labels}{Space between the labels}

\item{label_orientation}{\code{'outside'} to put the labels on the
outside of the circle, \code{'inside'} to put them on the inside.}

\item{sort_sectors}{If \code{TRUE}, the sectors will be plotted around the
circle in alphabetical order. Otherwise, they will be in the order in which
they appear in \code{ideogram_data}}
}
\value{
Generates an image of the initial ideogram track which can then be
added to with various other functions.
}
\description{
Draws the ideogram (sectors around a circle representing
sequences of interest, like chromosomes), labels and genomic axis in
preparation for the addition of other tracks like
\code{\link{drawFeatureTrack}} or \code{\link{drawLinegraphTrack}}.
}
\examples{
## normal/standard usage
ideogram <- data.frame(chr=paste0('chr', c(1:19, 'X', 'Y')),
start=rep(0, 21),
end=c(195471971, 182113224, 160039680, 156508116, 151834684, 149736546,
145441459, 129401213, 124595110, 130694993, 122082543, 120129022,
120421639, 124902244, 104043685, 98207768, 94987271, 90702639, 61431566,
171031299, 91744698))
gmovizInitialise(ideogram)

## zooming a sector
gmovizInitialise(ideogram, zoom_sectors='chr19', zoom_size=0.2)

## custom sector width
small_ideogram <- data.frame(chr=c('region 1', 'region 2', 'region 3'),
start=c(0, 0, 0), end=c(10000, 12000, 10000))
gmovizInitialise(small_ideogram, custom_sector_width=c(0.3, 0.3, 0.3))

## coverage rectangle
path <- system.file('extdata', 'ex1.bam', package='Rsamtools')
ideo <- getIdeogramData(path, wanted_chr='seq1')
coverage <- getCoverage(bam_file=path, regions_of_interest='seq1',
window_size=30)
gmovizInitialise(ideo, coverage_rectangle='seq1', coverage_data=coverage)
}
\seealso{
The \code{\link{drawScatterplotTrack}},
\code{\link{drawFeatureTrack}} and \code{\link{drawLinegraphTrack}}, which
can be used to add information to this plot. Also
\code{\link{getIdeogramData}} which can be used to read in the needed
ideogram data for this function.
}
