% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmoviz.R
\name{drawFeatureTrack}
\alias{drawFeatureTrack}
\title{Add a 'feature' track to an existing plot}
\usage{
drawFeatureTrack(feature_data, flipped_sector = NULL,
  feature_label_cutoff = 50, track_height = 0.1,
  feature_label_size = 0.9, label_track_height = 0.1 *
  feature_label_size, coverage_rectangle = NULL, coverage_data = NULL,
  internal = FALSE, feature_outline = TRUE)
}
\arguments{
\item{feature_data}{A data frame or \linkS4class{GRanges} containing the
'features' to plot. \itemize{
\item GRanges input should contain \code{label}, \code{colour},
\code{shape} and \code{track} as metadata columns.
\item Data frame should contain \code{label}, \code{colour}, \code{shape}
and \code{track}, as well as the additional columns \code{chr}, \code{start}
and \code{end}} Please see below for a detailed description of these
columns, and \code{\link{getFeatures}} for a function which can read this
information in from a .gff file.}

\item{flipped_sector}{A vector of sectors that will have their genomic
position (x values) reversed (ascending in anti-clockwise direction, as
opposed to the usual ascending in a clock-wise direction).}

\item{feature_label_cutoff}{To enhance readability when the shapes are
small, those labels belonging to features smaller than
\code{feature_label_cutoff} will instead be plotted on a new track closer
to the centre of the circle, rather than inside the shapes themselves.}

\item{track_height}{The height (proportion of the circle) taken up by
\bold{each track} of features. The default value of \code{0.1} is
appropriate for up to 2 feature tracks; if you get an error due to running
out of space please reduce this.}

\item{feature_label_size}{Size of the feature labels.}

\item{label_track_height}{Size of the track on which to plot the labels.}

\item{coverage_rectangle, coverage_data}{If, when initialising the graph you
have used coverage_rectangleangle AND you want to plot features on the
outermost track (track 0), please fill these in the same as in your
\code{gmovizInitialise} function call. \strong{Otherwise, there is no need
to supply these}.}

\item{internal}{For internal use only.}

\item{feature_outline}{Should a black outline be drawn around the feature
shape? (It is recommended to set this to \code{FALSE} when dealing with
very small features)}
}
\value{
Adds a 'feature' track to an existing plot.
}
\description{
Adds to an existing plot a track which displays 'features'
(e.g. genes, indels, primer sequences etc) using coloured shapes. Note that
you must have initialised the circular plot (by
\code{\link{gmovizInitialise}} first).
}
\section{Feature data format}{

The feature data \linkS4class{GRanges} contains four metadata columns:
\describe{
\item{label}{A character string which will be used to label the feature. It
is suggested to keep this label relatively short, if possible.}
\item{colour}{A character string of a colour to use. Supports hex colours
(\emph{e.g. #000000}) and named R colours (\emph{e.g. red}).}
\item{shape}{The shape that will be used to represent the feature: \itemize{
\item \code{'rectangle'}
\item \code{'forward_arrow'}
\item \code{'reverse_arrow'}
\item \code{'upwards_triangle'} (out of the circle).
\item \code{'downwards_triangle'} (into the circle).} It is suggested to use
\code{'forward_arrow'} for genes on the forward strand and
\code{'reverse_arrow'} for genes on the reverse strand.}
\item{track}{The index of the track on which to plot the feature: \itemize{
\item 0 represents the outermost track, where the ideogram rectangles that
represent sequences/chromosomes are plotted.
\item 1 is the conventional (default) track on which to plot a feature.
\item 2, 3 and so on are further into the centre of the circle.} It is
strongly recommended to keep the tracks below 3, otherwise there may not be
enough space in the circle to fit them all.}}
These columns are all \strong{optional}. If you don't supply them, then
default values will be added as follows: \describe{
\item{label}{\code{''}}
\item{colour}{a colour allocated from \code{\link{rich_colours}}}
\item{shape}{\code{'rectangle'}}
\item{track}{\code{1}}
}
}

\examples{
## plasmid map
plasmid_ideogram <- data.frame(chr='plasmid', start=0, end=2500)

plasmid_features <- GRanges(seqnames=rep('plasmid', 4),
ranges=IRanges(start=c(0, 451, 901, 1700), end=c(450, 900, 1400, 2200)),
colour = c('#d44a9f', '#4a91d4', '#7ad44a', '#d49d4a'),
label = c('promoter', 'gene', 'GFP', 'ampR'),
shape = c('rectangle', 'forward_arrow', 'forward_arrow', 'reverse_arrow'),
track = rep(1, 4))

## for a simple case like this you might as well use the featureDiagram
## function because it's only 1 function call, whereas here we need two:
gmovizInitialise(plasmid_ideogram)
drawFeatureTrack(plasmid_features)

## however the drawFeatureTrack function allows more flexibility e.g. if you
## want to add features to a plot containing numerical data for example:
## data
scatter_data <- GRanges(rep('plasmid', 50),
IRanges(start=sample(1:3000, 50), width=2),
scatter=rnorm(50, mean=4, sd=1))

## plotting
gmovizInitialise(plasmid_ideogram)
drawScatterplotTrack(plot_data=scatter_data)
drawFeatureTrack(plasmid_features, track_height = 0.15)
}
\seealso{
\code{\link{featureDiagram}} for a function that, while
slightly less flexible, generates an entire visualisation in one go. Also
\code{\link{getFeatures}} for a function that can read the feature data in
from a .gff file.
}
