% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{intern.sam}
\alias{intern.sam}
\alias{intern.cov}
\title{Internal function}
\usage{
intern.sam(y, X, mu, phi)

intern.cov(y, X, mu, phi)
}
\arguments{
\item{y}{response variable: numeric vector of length \code{n}}

\item{X}{covariate set: numeric matrix with \code{n} rows (samples)
and \code{p} columns (covariates)}

\item{mu}{mean parameters: numeric vector of length \code{n}}

\item{phi}{dispersion parameter: non-negative real number}
}
\value{
Both functions return a numeric vector.
}
\description{
These functions calculate the contribution of covariate
or samples to the test statistic.
They are called by the function \code{\link{proprius}}.
}
\examples{
# simulate high-dimensional data
n <- 30
p <- 100
set.seed(1)
y <- rnbinom(n,mu=10,size=1/0.25)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)

# prepare arguments
mu <- rep(mean(y),n)
phi <- (var(y)-mean(y))/mean(y)^2 

# decompose test statistic
intern.sam(y,X,mu,phi)
intern.cov(y,X,mu,phi)

}
\references{
A Rauschenberger, MA Jonker, MA van de Wiel, and RX Menezes (2016).
"Testing for association between RNA-Seq and high-dimensional data",
\emph{BMC Bioinformatics}. 17:118.
\href{http://dx.doi.org/10.1186/s12859-016-0961-5}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0961-5.pdf}{pdf}
(open access)

JJ Goeman, SA van de Geer, F de Kort, and HC van Houwelingen (2004).
"A global test for groups of genes:
testing association with a clinical outcome",
\emph{Bioinformatics}. 20:93-99.
\href{http://dx.doi.org/10.1093/bioinformatics/btg382}{html}
\href{http://bioinformatics.oxfordjournals.org/content/20/1/93.full.pdf}{pdf}
(open access)
}
\seealso{
This is an \code{\link{internal}} function. The user functions 
of the R package \code{\link{globalSeq}} are \code{\link{cursus}},
\code{\link{omnibus}}, and \code{\link{proprius}}.
}
\keyword{internal}
