% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_degree.R, R/glm_hub.R, R/glm_orphan.R,
%   R/glm_sparse_net.R
\name{cv.glmDegree}
\alias{cv.glmDegree}
\alias{cv.glmHub}
\alias{cv.glmOrphan}
\alias{cv.glmSparseNet}
\title{Calculate cross validating GLM model with network-based regularization}
\usage{
cv.glmDegree(
  xdata,
  ydata,
  network,
  options = networkOptions(),
  experiment = NULL,
  network.options = deprecated(),
  experiment.name = deprecated(),
  ...
)

cv.glmHub(
  xdata,
  ydata,
  network,
  options = networkOptions(),
  experiment = NULL,
  network.options = deprecated(),
  experiment.name = deprecated(),
  ...
)

cv.glmOrphan(
  xdata,
  ydata,
  network,
  options = networkOptions(),
  experiment = NULL,
  network.options = deprecated(),
  experiment.name = deprecated(),
  ...
)

cv.glmSparseNet(
  xdata,
  ydata,
  network,
  options = networkOptions(),
  experiment = NULL,
  network.options = deprecated(),
  experiment.name = deprecated(),
  ...
)
}
\arguments{
\item{xdata}{input data, can be a matrix or MultiAssayExperiment.}

\item{ydata}{response data compatible with glmnet.}

\item{network}{type of network, see below.}

\item{options}{options to calculate network.}

\item{experiment}{name of experiment to use as input in
MultiAssayExperiment object (only if xdata is an object of this class).}

\item{network.options}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{experiment.name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{...}{parameters that \code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}} accepts.}
}
\value{
an object just as \code{cv.glmnet}
}
\description{
network parameter accepts:
}
\details{
\itemize{
\item string to calculate network based on data (correlation, covariance)
\item matrix representing the network
\item vector with already calculated penalty weights (can also be used directly
glmnet)
}
}
\section{Functions}{
\itemize{
\item \code{cv.glmDegree()}: penalizes nodes with small degree
\emph{(inversion penalization \code{h(x) = 1 / x})}.

\item \code{cv.glmHub()}: penalizes nodes with small degree
\emph{(normalized heuristic that promotes nodes with many edges)}.

\item \code{cv.glmOrphan()}: penalizes nodes with high degree
\emph{(normalized heuristic that promotes nodes with few edges)}.

}}
\examples{
# Degree penalization

xdata <- matrix(rnorm(100), ncol = 5)
cv.glmDegree(
    xdata,
    rnorm(nrow(xdata)),
    "correlation",
    family = "gaussian",
    nfolds = 5,
    options = networkOptions(minDegree = .2)
)
# Hub penalization

xdata <- matrix(rnorm(100), ncol = 5)
cv.glmHub(
    xdata,
    rnorm(nrow(xdata)),
    "correlation",
    family = "gaussian",
    nfolds = 5,
    options = networkOptions(minDegree = .2)
)
# Orphan penalization

xdata <- matrix(rnorm(100), ncol = 5)
cv.glmOrphan(
    xdata,
    rnorm(nrow(xdata)),
    "correlation",
    family = "gaussian",
    nfolds = 5,
    options = networkOptions(minDegree = .2)
)
\donttest{
# Gaussian model
xdata <- matrix(rnorm(500), ncol = 5)
cv.glmSparseNet(
    xdata, rnorm(nrow(xdata)), "correlation",
    family = "gaussian"
)
cv.glmSparseNet(
    xdata, rnorm(nrow(xdata)), "covariance",
    family = "gaussian"
)
}
\dontshow{if (requireNamespace("MultiAssayExperiment", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
#
#
# Using MultiAssayExperiment with survival model
library(MultiAssayExperiment)
data("miniACC", package = "MultiAssayExperiment")

xdata <- miniACC

#
# build valid data with days of last follow up or to event
event.ix <- which(!is.na(xdata$days_to_death))
cens.ix <- which(!is.na(xdata$days_to_last_followup))
xdata$surv_event_time <- array(NA, nrow(colData(xdata)))
xdata$surv_event_time[event.ix] <- xdata$days_to_death[event.ix]
xdata$surv_event_time[cens.ix] <- xdata$days_to_last_followup[cens.ix]

#
# Keep only valid individuals
valid.ix <- as.vector(!is.na(xdata$surv_event_time) &
    !is.na(xdata$vital_status) &
    xdata$surv_event_time > 0)
xdata.valid <- xdata[, rownames(colData(xdata))[valid.ix]]
ydata.valid <- colData(xdata.valid)[, c("surv_event_time", "vital_status")]
colnames(ydata.valid) <- c("time", "status")

#
cv.glmSparseNet(
    xdata.valid,
    ydata.valid,
    nfolds     = 5,
    family     = "cox",
    network    = "correlation",
    experiment = "RNASeq2GeneNorm"
)
\dontshow{\}) # examplesIf}
}
\seealso{
Model with the same penalizations \code{\link[=glmSparseNet]{glmSparseNet()}}.
}
