% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,SeqDiff,ANY-method}
\title{plot method for SeqDiff object}
\usage{
\S4method{plot}{SeqDiff,ANY}(
  x,
  width = 50,
  title = "auto",
  xlab = "Nucleotide Position",
  by = "bar",
  fill = "firebrick",
  colors = c(A = "#ff6d6d", C = "#769dcc", G = "#f2be3c", T = "#74ce98"),
  xlim = NULL
)
}
\arguments{
\item{x}{SeqDiff object}

\item{width}{bin width}

\item{title}{plot title}

\item{xlab}{xlab}

\item{by}{one of 'bar' and 'area'}

\item{fill}{fill color of upper part of the plot}

\item{colors}{color of lower part of the plot}

\item{xlim}{limits of x-axis}
}
\value{
plot
}
\description{
plot method for SeqDiff object
}
\examples{
fas <- list.files(system.file("extdata", "GVariation", package="ggmsa"),
                  pattern="fas", full.names=TRUE)
x1 <- seqdiff(fas[1], reference=1)
plot(x1)
}
\author{
guangchuang yu
}
