% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binned_manhattan.R
\name{binned_manhattan_plot}
\alias{binned_manhattan_plot}
\alias{binned_manhattan_plot.default}
\alias{binned_manhattan_plot.MPdataBinned}
\alias{binned_manhattan_plot.data.frame}
\alias{binned_manhattan_plot,GRanges-method}
\title{Plot Binned Manhattan Plot}
\usage{
binned_manhattan_plot(x, ...)

\method{binned_manhattan_plot}{default}(x, ...)

\method{binned_manhattan_plot}{MPdataBinned}(
  x,
  outfn = NULL,
  signif.lwd = 1,
  bin.outline = FALSE,
  bin.outline.alpha = 0.2,
  highlight.colname = NULL,
  highlight.counts = TRUE,
  bin.palette = "viridis::plasma",
  bin.alpha = 0.9,
  palette.direction = 1,
  nonsignif.default = NULL,
  show.legend = TRUE,
  legend.title = NULL,
  background.col = c("grey90", "white"),
  background.alpha = 0.7,
  plot.title = ggplot2::waiver(),
  plot.subtitle = ggplot2::waiver(),
  plot.width = 10,
  plot.height = 5,
  plot.scale = 1,
  ...
)

\method{binned_manhattan_plot}{data.frame}(
  x,
  bins.x = 10,
  bins.y = 100,
  chr.gap.scaling = 0.4,
  signif = c(5e-08, 1e-05),
  pval.colname = "pval",
  chr.colname = "chr",
  pos.colname = "pos",
  chr.order = NULL,
  signif.col = NULL,
  preserve.position = TRUE,
  pval.log.transform = TRUE,
  summarise.expression.list = NULL,
  outfn = NULL,
  signif.lwd = 1,
  bin.outline = FALSE,
  bin.outline.alpha = 0.2,
  highlight.colname = NULL,
  highlight.counts = TRUE,
  bin.palette = "viridis::plasma",
  bin.alpha = 0.9,
  palette.direction = 1,
  nonsignif.default = NULL,
  show.legend = TRUE,
  legend.title = NULL,
  background.col = c("grey90", "white"),
  background.alpha = 0.7,
  plot.title = ggplot2::waiver(),
  plot.subtitle = ggplot2::waiver(),
  plot.width = 10,
  plot.height = 5,
  plot.scale = 1,
  ...
)

\S4method{binned_manhattan_plot}{GRanges}(
  x,
  bins.x = 10,
  bins.y = 100,
  chr.gap.scaling = 0.4,
  signif = c(5e-08, 1e-05),
  pval.colname = "pval",
  chr.order = NULL,
  signif.col = NULL,
  preserve.position = TRUE,
  pval.log.transform = TRUE,
  summarise.expression.list = NULL,
  outfn = NULL,
  signif.lwd = 1,
  bin.outline = FALSE,
  bin.outline.alpha = 0.2,
  highlight.colname = NULL,
  highlight.counts = TRUE,
  bin.palette = "viridis::plasma",
  bin.alpha = 0.9,
  palette.direction = 1,
  nonsignif.default = NULL,
  show.legend = TRUE,
  legend.title = NULL,
  background.col = c("grey90", "white"),
  background.alpha = 0.7,
  plot.title = ggplot2::waiver(),
  plot.subtitle = ggplot2::waiver(),
  plot.width = 10,
  plot.height = 5,
  plot.scale = 1,
  ...
)
}
\arguments{
\item{x}{a \code{data.frame} or any other extension of a data frame. It can also be a \code{MPdata} object.}

\item{...}{Ignored}

\item{outfn}{a character. File name to save the Manhattan Plot. If \code{outfn}
is supplied (i.e. \code{!is.null(outfn)}), then the plot is not drawn in
the graphics window.}

\item{signif.lwd}{a number. Line width of the significance threshold line.}

\item{bin.outline}{a logical. Outline each bin. The bins are colored black.}

\item{bin.outline.alpha}{a number. Alpha value of the bin outline.}

\item{highlight.colname}{a character. If you desire to color certain points
(e.g. significant variants) rather than color by chromosome, you can specify the
category in this column, and provide the color mapping in \code{highlight.col}.
Ignored if \code{NULL}.}

\item{highlight.counts}{a logical. If logical, the bins are colored based on the number of points in each block.}

\item{bin.palette}{a character. Palette to color the bins. Only palettes supported by the package \code{paletteer} are supported. More in details.}

\item{bin.alpha}{a number. Alpha value of the bins.}

\item{palette.direction}{a number. Direction of the palette. 1 for increasing and -1 for decreasing.}

\item{nonsignif.default}{a character. Default color for bins that are not significant.}

\item{show.legend}{a logical. Show legend if bins are colored based on a variable.}

\item{legend.title}{a character. Title of the legend.}

\item{background.col}{a character. Color of the background panels. Set to \code{NULL} for no color.}

\item{background.alpha}{a number. Alpha value of the background panels.}

\item{plot.title}{a character. Plot title}

\item{plot.subtitle}{a character. Plot subtitle}

\item{plot.width}{a numeric. Plot width in inches. Corresponds to \code{width} argument in \code{ggsave} function.}

\item{plot.height}{a numeric. Plot height in inches. Corresponds to \code{height} argument in \code{ggsave} function.}

\item{plot.scale}{a numeric. Plot scale. Corresponds to \code{scale} argument in \code{ggsave} function.}

\item{bins.x}{an integer. number of blocks to horizontally span the longest chromosome}

\item{bins.y}{an integer. number of blocks to vertically span the plot}

\item{chr.gap.scaling}{a numeric. scaling factor for gap between chromosome if you desire to change it
if x is an \code{MPdata} object, then the gap will scale relative to the gap in the object.}

\item{signif}{a numeric vector. Significant p-value thresholds to be drawn for manhattan plot.
At least one value should be provided. Default value is c(5e-08, 1e-5).
If \code{signif} is not \code{NULL} and \code{x} is an \code{MPdata} object,
\code{signif} argument overrides the value inside \code{MPdata}.}

\item{pval.colname}{a character. Column name of \code{x} containing p.value.}

\item{chr.colname}{a character. Column name of \code{x} containing chromosome.}

\item{pos.colname}{a character. Column name of \code{x} containing position.}

\item{chr.order}{a character vector. Order of chromosomes presented in manhattan plot.}

\item{signif.col}{a character vector of equal length as \code{signif}.
It contains colors for the lines drawn at \code{signif}.
If \code{NULL}, the smallest value is colored black while others are grey. If \code{x} is an \code{MPdata} object,
behaves similarly to \code{signif}.}

\item{preserve.position}{a logical. If \code{TRUE}, the width of each chromosome reflect the
number of variants and the position of each variant is correctly scaled? If \code{FALSE}, the
width of each chromosome is equal and the variants are equally spaced.}

\item{pval.log.transform}{a logical. If \code{TRUE}, the p-value will be transformed to -log10(p-value).}

\item{summarise.expression.list}{a list of formulas to summarise data for each bin. Check details for more information.}
}
\description{
Contrary to the traditional manhattan plot, which plots all the points, the
binned manhattan plot vertically and horizontally bins the variants into blocks.
This speeds up plotting and reduces clutter in the case of high number of variants.
The colors of the blocks can also be used to summarise the variants within each
block and highlight certain features.
}
\details{
Similar to \code{manhattan_plot}, this function accepts summary statistics from GWAS and plots manhattan plot.
The difference is that the variants are binned.
The number of blocks can be controlled by \code{bins.x} and \code{bins.y}.
The blocks can be colored based on a column in the data frame.

Palette for coloring the bins can be chosen from the package \href{https://emilhvitfeldt.github.io/paletteer/}{\code{paletteer}}.
Only palettes available in \code{paletteer} are supported. Furthermore, what palette you can use depends on what kind of
variable you are using to fill the bins. Use discrete palette for categorical variable and continuous palette for continuous variable.
}
