% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{edge_numeric_sum}
\alias{edge_numeric_sum}
\title{edge_numeric_sum}
\usage{
edge_numeric_sum(
  num,
  num_combine = mean,
  how = "any",
  name = "name",
  sep = " ",
  remove_dot = TRUE
)
}
\arguments{
\item{num}{named vector or tibble with id and value column}

\item{num_combine}{how to combine number when multiple hit in the same node}

\item{how}{`any` or `all`}

\item{name}{name of column to match for}

\item{sep}{separater for name, default to " "}

\item{remove_dot}{remove "..." in the name}
}
\value{
numeric vector
}
\description{
add numeric attribute to edge of tbl_graph based on node values
The implementation is based on the paper by
Adnan et al. 2020 (https://doi.org/10.1186/s12859-020-03692-2).
}
\examples{
graph <- create_test_pathway()
graph <- graph |>
            activate("edges") |>
            mutate(num=edge_numeric_sum(c(1.2,-1.2) |>
            setNames(c("TRIM21","DDX41")), name="graphics_name"))
}
