% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_data.R
\name{replace_data}
\alias{replace_data}
\alias{\%+\%}
\alias{\%+\%,ggcyto_GatingLayout-method}
\alias{\%+\%,ggcyto_GatingLayout,ANY-method}
\alias{\%+\%,ggcyto-method}
\title{replace current cytometry data}
\usage{
e1 \%+\% e2
}
\arguments{
\item{e1}{the ggcyto object}

\item{e2}{the new cytometry data . It can be 'GatingSet' or 'flowSet'.}
}
\value{
the new ggcyto object
}
\description{
It essentially reconstructs the entire ggcyto plot object based on the new data and the original mapping and layers
recorded in the plot object.
}
\examples{
dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_bcell_auto",full = TRUE))
gs1 <- gs[1]
gs2 <- gs[2]

#construct the ggcyto object for gs1
p <- ggcyto(gs1, aes(cd24, cd38)) + geom_hex(bins = 128)
p <- p + geom_gate("Transitional") #add gate
#customize the stats layer
p <- p + geom_stats(type = "count", size = 6,  color = "white", fill = "black", adjust = 0.3)
#customize the layer
p <- p + labs_cyto("channel")
#customize the axis limits
p <- p + ggcyto_par_set(limits = "instrument")
#add another population as the overlay dots
p <- p + geom_overlay("IgD-CD27-", col = "black", size = 1.2, alpha = 0.4)
p

#replace the data with gs2 and see the same visual effect
p \%+\% gs2

}
